/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp;

import io.bootique.BQModuleProvider;
import io.bootique.BQRuntime;
import io.bootique.Bootique;
import io.bootique.BootiqueException;
import io.bootique.command.CommandOutcome;
import io.bootique.di.Injector;
import io.bootique.help.HelpOption;
import io.sarl.apputils.bootiqueapp.Messages;
import io.sarl.apputils.bootiqueapp.mdhelp.GenerateMarkdownHelpCommand;
import io.sarl.apputils.bootiqueapp.utils.JulPatternFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BootiqueMain {
    public static final int ERROR_CODE = 255;
    public static final String DEFAULT_LOG_FORMAT = "%-5p %m%n";
    public static final String D_PATTERN = "(?:(?:\\-\\-?)|(?:\\/))D([^=]+)=(.*)";
    private final BQModuleProvider[] providers;
    private final boolean experimental;

    public BootiqueMain(BQModuleProvider ... providers) {
        this(false, providers);
    }

    public BootiqueMain(boolean experimental, BQModuleProvider ... providers) {
        this.experimental = experimental;
        this.providers = providers;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    protected BQRuntime createRuntime(String ... args) {
        Bootique bootique = Bootique.app((String[])args).autoLoadModules();
        return this.createRuntime(bootique);
    }

    protected BQRuntime createRuntime(Class<? extends BQModuleProvider>[] modules, String ... args) {
        Bootique bootique = Bootique.app((String[])args);
        for (Class<? extends BQModuleProvider> providerType : modules) {
            BQModuleProvider provider;
            try {
                provider = providerType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable exception) {
                provider = null;
            }
            if (provider == null) continue;
            bootique = bootique.moduleProvider(provider);
        }
        return this.createRuntime(bootique);
    }

    private BQRuntime createRuntime(Bootique bootique) {
        Bootique bootiqueInstance = bootique;
        if (this.providers != null) {
            for (BQModuleProvider provider : this.providers) {
                bootiqueInstance = bootiqueInstance.moduleProvider(provider);
            }
        }
        BQRuntime runtime = bootiqueInstance.createRuntime();
        return runtime;
    }

    public int runCommand(String ... args) {
        Logger rootLogger = Logger.getGlobal();
        try {
            String[] fargs;
            BQRuntime runtime;
            CommandOutcome outcome;
            for (Handler handler : rootLogger.getHandlers()) {
                handler.setFormatter(new JulPatternFormatter(DEFAULT_LOG_FORMAT));
            }
            if (this.isExperimental()) {
                rootLogger.warning(Messages.BootiqueMain_0);
            }
            if (!(outcome = (runtime = this.createRuntime(fargs = BootiqueMain.filterCommandLineArguments(args))).run()).isSuccess() && outcome.getException() != null) {
                rootLogger.log(Level.SEVERE, outcome.getMessage(), outcome.getException());
            }
            return outcome.getExitCode();
        }
        catch (BootiqueException exception) {
            CommandOutcome outcome = exception.getOutcome();
            if (outcome != null) {
                if (outcome.getException() != null) {
                    rootLogger.log(Level.SEVERE, outcome.getMessage(), outcome.getException());
                } else {
                    rootLogger.severe(outcome.getMessage());
                }
                return outcome.getExitCode();
            }
            rootLogger.severe(exception.getLocalizedMessage());
        }
        catch (Throwable exception) {
            rootLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        return 255;
    }

    public final List<HelpOption> getOptions() {
        BQRuntime runtime = this.createRuntime(new String[0]);
        return GenerateMarkdownHelpCommand.getOptions((Injector)runtime.getInstance(Injector.class));
    }

    public final List<HelpOption> getOptionsForModules(Class<? extends BQModuleProvider>[] modules) {
        BQRuntime runtime = this.createRuntime(modules, new String[0]);
        return GenerateMarkdownHelpCommand.getOptions((Injector)runtime.getInstance(Injector.class));
    }

    public static Class<? extends BQModuleProvider>[] getStaticModuleProvidersFor(String[] names) {
        ArrayList<Class<BQModuleProvider>> providers = new ArrayList<Class<BQModuleProvider>>(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                Class<?> type = Class.forName(names[i]);
                if (type == null || !BQModuleProvider.class.isAssignableFrom(type)) continue;
                providers.add(type.asSubclass(BQModuleProvider.class));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return providers.toArray(new Class[providers.size()]);
    }

    public static String[] filterCommandLineArguments(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(D_PATTERN);
        for (String arg : args) {
            Matcher matcher = pattern.matcher(arg);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                System.setProperty(name, value);
                continue;
            }
            list.add(arg);
        }
        String[] tab = new String[list.size()];
        list.toArray(tab);
        return tab;
    }
}

