/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;

public enum Level {
    OFF(org.apache.log4j.Level.OFF, java.util.logging.Level.OFF),
    ERROR(org.apache.log4j.Level.ERROR, java.util.logging.Level.SEVERE),
    WARNING(org.apache.log4j.Level.WARN, java.util.logging.Level.WARNING),
    INFO(org.apache.log4j.Level.INFO, java.util.logging.Level.INFO),
    DEBUG(org.apache.log4j.Level.DEBUG, java.util.logging.Level.FINE),
    TRACE(org.apache.log4j.Level.TRACE, java.util.logging.Level.FINEST),
    ALL(org.apache.log4j.Level.ALL, java.util.logging.Level.ALL);

    private final org.apache.log4j.Level log4j;
    private final java.util.logging.Level jul;

    private Level(org.apache.log4j.Level log4j, java.util.logging.Level jul) {
        this.log4j = log4j;
        this.jul = jul;
    }

    @JsonCreator
    public static Level valueOfCaseInsensitive(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new NullPointerException("Name is null");
        }
        return Level.valueOf(name.toUpperCase());
    }

    @JsonValue
    public String toJsonString() {
        return this.name().toLowerCase();
    }

    public org.apache.log4j.Level toLog4j() {
        return this.log4j;
    }

    public java.util.logging.Level toJul() {
        return this.jul;
    }

    public static Level valueOf(org.apache.log4j.Level level) {
        if (level != null) {
            int idx = level.toInt();
            for (Level lvl : Level.values()) {
                if (lvl.toLog4j().toInt() > idx) continue;
                return lvl;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Level valueOf(java.util.logging.Level level) {
        if (level != null) {
            int idx = level.intValue();
            for (Level lvl : Level.values()) {
                if (lvl.toJul().intValue() > idx) continue;
                return lvl;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getLabels() {
        StringBuilder labels = new StringBuilder();
        for (Level level : Level.values()) {
            if (labels.length() > 0) {
                labels.append(", ");
            }
            labels.append(level.toJsonString());
        }
        return labels.toString();
    }
}

