/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.config;

import com.google.common.base.Strings;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.ConfigurationFactory;
import io.sarl.apputils.bootiqueapp.config.Level;
import java.util.Objects;
import java.util.logging.Logger;

@BQConfig(value="Configuration of the loggers")
public class LogConfig
implements Comparable<LogConfig> {
    public static final String PREFIX = "log";
    public static final String LEVEL = "log.level";
    public static final Level DEFAULT_LEVEL = Level.INFO;
    public static final String LOG_FORMAT = "log.logFormat";
    public static final String DEFAULT_LOG_FORMAT = "%-5p %m%n";
    private Level level;
    private String logFormat;

    public static LogConfig getConfiguration(ConfigurationFactory configFactory) {
        assert (configFactory != null);
        return (LogConfig)configFactory.config(LogConfig.class, PREFIX);
    }

    public Level getLevel() {
        if (this.level == null) {
            this.level = DEFAULT_LEVEL;
        }
        return this.level;
    }

    @BQConfigProperty(value="Logging level of a given logger and its children.")
    public void setLevel(Level level) {
        this.level = level;
    }

    public Logger configureLogger(Logger logger) {
        String format = this.getLogFormat();
        if (!Strings.isNullOrEmpty((String)format)) {
            // empty if block
        }
        logger.setLevel(this.getLevel().toJul());
        return logger;
    }

    public Logger configureLogger(String loggerName) {
        return this.configureLogger(Logger.getLogger(loggerName));
    }

    public String getLogFormat() {
        if (this.logFormat == null) {
            this.logFormat = DEFAULT_LOG_FORMAT;
        }
        return this.logFormat;
    }

    @BQConfigProperty(value="Log format specification used by child appenders unless redefined at the appender level, or not relevant for a given type of appender. The spec is compatible with Log4j framework. Default format is '%-5p %m%n'.")
    public void setLogFormat(String format) {
        this.logFormat = format;
    }

    public String toString() {
        return Objects.toString((Object)this.level);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogConfig) {
            LogConfig logConfig = (LogConfig)obj;
            return this.level == logConfig.getLevel();
        }
        return false;
    }

    public int hashCode() {
        return this.level == null ? 0 : this.level.hashCode();
    }

    @Override
    public int compareTo(LogConfig o) {
        if (o == null) {
            return 1;
        }
        if (this.level == o.level) {
            return 0;
        }
        if (this.level == null) {
            return o.level == null ? 0 : -1;
        }
        if (o.level == null) {
            return 1;
        }
        return this.level.compareTo(o.level);
    }
}

