/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.mdconfig;

import com.google.common.base.Strings;
import com.google.common.primitives.Primitives;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.meta.MetadataNode;
import io.bootique.meta.application.CommandMetadata;
import io.bootique.meta.config.ConfigListMetadata;
import io.bootique.meta.config.ConfigMapMetadata;
import io.bootique.meta.config.ConfigMetadataNode;
import io.bootique.meta.config.ConfigMetadataVisitor;
import io.bootique.meta.config.ConfigObjectMetadata;
import io.bootique.meta.config.ConfigValueMetadata;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import io.sarl.apputils.bootiqueapp.mdconfig.Messages;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GenerateMarkdownConfigCommand
extends CommandWithMetadata {
    private static final String CLI_NAME = "generatemarkdownconfighelp";
    private static final String CLI_ROOT_PROPERTY = "generatemarkdownconfighelp.root";
    private static final String PIPE = "&#124;";
    private final ModulesMetadata modulesMetadata;

    public GenerateMarkdownConfigCommand(ModulesMetadata modulesMetadata) {
        this(modulesMetadata, GenerateMarkdownConfigCommand.class, Messages.GenerateMarkdownConfigCommand_0);
    }

    protected GenerateMarkdownConfigCommand(ModulesMetadata modulesMetadata, Class<? extends GenerateMarkdownConfigCommand> commandType, String description) {
        super(CommandMetadata.builder(commandType).description(description).name(CLI_NAME));
        this.modulesMetadata = modulesMetadata;
    }

    public static List<ConfigMetadataNode> getConfigurationParameters(ModulesMetadata modulesMetadata, String selectedRoot) {
        Predicate<ConfigMetadataNode> filter;
        if (Strings.isNullOrEmpty((String)selectedRoot)) {
            filter = it -> true;
        } else {
            String prefix = selectedRoot + ".";
            filter = it -> it.getName().equals(selectedRoot) || it.getName().startsWith(prefix);
        }
        List sortedModules = modulesMetadata.getModules().stream().sorted(Comparator.comparing(ModuleMetadata::getName)).collect(Collectors.toList());
        List<ConfigMetadataNode> sortedConfigs = sortedModules.stream().map(ModuleMetadata::getConfigs).flatMap(Collection::stream).filter(filter).sorted(Comparator.comparing(MetadataNode::getName)).collect(Collectors.toList());
        return sortedConfigs;
    }

    public static List<List<String>> getConfigurationParametersAsStrings(ModulesMetadata modulesMetadata, String selectedRoot, boolean replacePipes, boolean addLineIfNoData) {
        List<ConfigMetadataNode> parameters = GenerateMarkdownConfigCommand.getConfigurationParameters(modulesMetadata, selectedRoot);
        ArrayList<List<String>> matrix = new ArrayList<List<String>>(parameters.size());
        Visitor visitor = new Visitor(matrix, replacePipes);
        for (ConfigMetadataNode parameter : parameters) {
            parameter.accept((ConfigMetadataVisitor)visitor);
        }
        if (addLineIfNoData && matrix.isEmpty()) {
            GenerateMarkdownConfigCommand.addToMatrix(matrix);
        }
        return matrix;
    }

    private static void addToMatrix(List<List<String>> matrix, String property, String type, String description) {
        matrix.add(Arrays.asList("", property, type, description));
    }

    private static void addToMatrix(List<List<String>> matrix, String module, String description) {
        matrix.add(Arrays.asList(module, "", "", description));
    }

    private static void addToMatrix(List<List<String>> matrix) {
        matrix.add(Arrays.asList("", "", "", ""));
    }

    public CommandOutcome run(Cli cli) {
        String rootName = System.getProperty(CLI_ROOT_PROPERTY, null);
        List<List<String>> parameters = GenerateMarkdownConfigCommand.getConfigurationParametersAsStrings(this.modulesMetadata, rootName, true, true);
        StringBuilder content = new StringBuilder();
        for (List<String> row : parameters) {
            boolean first = true;
            for (String cell : row) {
                if (first) {
                    first = false;
                    content.append("| ");
                } else {
                    content.append(" | ");
                }
                content.append(cell);
            }
            content.append(" |\n");
        }
        System.out.println(content.toString());
        return CommandOutcome.succeeded();
    }

    private static class Visitor
    implements ConfigMetadataVisitor<Void> {
        private final List<List<String>> matrix;
        private final Set<String> added = new TreeSet<String>();
        private final boolean replacePipes;
        private final Pattern setPattern = Pattern.compile("^set([A-Z])([a-zA-Z0-9]+)$");

        Visitor(List<List<String>> matrix, boolean replacePipes) {
            this.matrix = matrix;
            this.replacePipes = replacePipes;
        }

        private String prepareStr(String value) {
            String fixedValue = Strings.nullToEmpty((String)value);
            if (this.replacePipes) {
                return fixedValue.replace("|", GenerateMarkdownConfigCommand.PIPE);
            }
            return fixedValue;
        }

        private void printMetadata(ConfigMetadataNode metadata) {
            String name = this.prepareStr(metadata.getName());
            if (this.added.add(name)) {
                GenerateMarkdownConfigCommand.addToMatrix(this.matrix, name, this.prepareStr(metadata.getDescription()));
                Class type = (Class)metadata.getType();
                if (type == null) {
                    return;
                }
                for (Method setterMethod : type.getMethods()) {
                    Matcher matcher;
                    BQConfigProperty annotation;
                    if (!Modifier.isPublic(setterMethod.getModifiers()) || Modifier.isAbstract(setterMethod.getModifiers()) || Modifier.isStatic(setterMethod.getModifiers()) || setterMethod.getParameterCount() != 1 || (annotation = setterMethod.getAnnotation(BQConfigProperty.class)) == null || !(matcher = this.setPattern.matcher(setterMethod.getName())).matches()) continue;
                    String firstLetter = matcher.group(1);
                    String rest = matcher.group(2);
                    String propertyName = firstLetter.toLowerCase() + rest;
                    GenerateMarkdownConfigCommand.addToMatrix(this.matrix, this.prepareStr(propertyName), this.prepareStr(this.getTypeLabel(setterMethod.getParameterTypes()[0])), this.prepareStr(annotation.value()));
                }
            }
        }

        private String getTypeLabel(Class<?> type) {
            assert (type != null);
            Class uwt = Primitives.unwrap(type);
            if (uwt.isPrimitive()) {
                return uwt.getSimpleName();
            }
            if (CharSequence.class.isAssignableFrom(uwt)) {
                return "string";
            }
            if (uwt.isEnum()) {
                Class etype = uwt;
                StringBuilder buf = new StringBuilder();
                for (Enum cst : (Enum[])etype.getEnumConstants()) {
                    if (buf.length() > 0) {
                        buf.append(this.prepareStr(" | "));
                    }
                    buf.append("*\"");
                    buf.append(cst.name().toLowerCase());
                    buf.append("\"*");
                }
                return buf.toString();
            }
            if (Map.class.isAssignableFrom(type)) {
                return Map.class.getSimpleName();
            }
            if (Collection.class.isAssignableFrom(type)) {
                return Collection.class.getSimpleName();
            }
            return uwt.getSimpleName();
        }

        public Void visitObjectMetadata(ConfigObjectMetadata metadata) {
            this.printMetadata((ConfigMetadataNode)metadata);
            List<ConfigObjectMetadata> selfAndSubconfigs = metadata.getAllSubConfigs().map(md -> (ConfigObjectMetadata)md.accept((ConfigMetadataVisitor)new ConfigMetadataVisitor<ConfigObjectMetadata>(this){

                public ConfigObjectMetadata visitObjectMetadata(ConfigObjectMetadata visited) {
                    return visited.isAbstractType() || visited.getProperties().isEmpty() ? null : visited;
                }
            })).filter(md -> md != null).collect(Collectors.toList());
            if (!selfAndSubconfigs.isEmpty()) {
                selfAndSubconfigs.forEach(md -> this.printMetadata((ConfigMetadataNode)md));
            }
            return null;
        }

        public Void visitValueMetadata(ConfigValueMetadata metadata) {
            this.printMetadata((ConfigMetadataNode)metadata);
            return null;
        }

        public Void visitListMetadata(ConfigListMetadata metadata) {
            this.printMetadata((ConfigMetadataNode)metadata);
            return null;
        }

        public Void visitMapMetadata(ConfigMapMetadata metadata) {
            this.printMetadata((ConfigMetadataNode)metadata);
            return null;
        }
    }
}

