/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.mdhelp;

import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.di.Injector;
import io.bootique.help.HelpOption;
import io.bootique.help.HelpOptions;
import io.bootique.meta.application.ApplicationMetadata;
import io.bootique.meta.application.CommandMetadata;
import io.sarl.apputils.bootiqueapp.mdhelp.Messages;
import io.sarl.lang.core.util.CliUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenerateMarkdownHelpCommand
extends CommandWithMetadata {
    private static final String CLI_NAME = "generatemarkdownhelp";
    private static final String PIPE = "&#124;";
    private final Injector injector;

    public GenerateMarkdownHelpCommand(Injector injector) {
        this(injector, GenerateMarkdownHelpCommand.class, Messages.GenerateMarkdownHelpCommand_0);
    }

    protected GenerateMarkdownHelpCommand(Injector injector, Class<? extends GenerateMarkdownHelpCommand> commandType, String description) {
        super(CommandMetadata.builder(commandType).description(description).name(CLI_NAME));
        this.injector = injector;
    }

    public static List<HelpOption> getOptions(Injector runtime) {
        ApplicationMetadata application = (ApplicationMetadata)runtime.getInstance(ApplicationMetadata.class);
        HelpOptions helpOptions = new HelpOptions();
        application.getCommands().forEach(c -> {
            helpOptions.add(c.asOption());
            c.getOptions().forEach(o -> helpOptions.add(o));
        });
        application.getOptions().forEach(o -> helpOptions.add(o));
        return helpOptions.getOptions();
    }

    public static List<List<String>> getOptionsAsStrings(Injector runtime, boolean replacePipes) {
        List<HelpOption> options = GenerateMarkdownHelpCommand.getOptions(runtime);
        ArrayList<List<String>> matrix = new ArrayList<List<String>>(options.size());
        for (HelpOption option : options) {
            String valueName = option.getOption().getValueName();
            if (valueName == null || valueName.length() == 0) {
                valueName = "val";
            } else if (replacePipes) {
                valueName = valueName.replace("|", PIPE);
            }
            StringBuilder buffer0 = new StringBuilder();
            if (option.isShortNameAllowed()) {
                buffer0.append("-");
                buffer0.append(String.valueOf(option.getOption().getShortName()));
                switch (option.getOption().getValueCardinality()) {
                    case REQUIRED: {
                        buffer0.append(" ");
                        buffer0.append(valueName);
                        break;
                    }
                    case OPTIONAL: {
                        buffer0.append(" [");
                        buffer0.append(valueName);
                        buffer0.append("]");
                        break;
                    }
                }
            }
            if (option.isLongNameAllowed()) {
                if (option.isShortNameAllowed()) {
                    buffer0.append("<br>");
                }
                buffer0.append(CliUtilities.getCommandLineLongOptionPrefix());
                buffer0.append(option.getOption().getName());
                switch (option.getOption().getValueCardinality()) {
                    case REQUIRED: {
                        buffer0.append("=");
                        buffer0.append(valueName);
                        break;
                    }
                    case OPTIONAL: {
                        buffer0.append("[=");
                        buffer0.append(valueName);
                        buffer0.append("]");
                        break;
                    }
                }
            }
            StringBuilder buffer1 = new StringBuilder();
            String description = option.getOption().getDescription();
            if (description != null) {
                String text = description.replaceAll("[ \t\n\r\f]+", " ");
                text = text.replace("<", "&lt;");
                text = text.replace(">", "&gt;");
                if (replacePipes) {
                    text = text.replace("|", PIPE);
                }
                buffer1.append(description);
            }
            matrix.add(Arrays.asList(buffer0.toString(), buffer1.toString()));
        }
        return matrix;
    }

    public CommandOutcome run(Cli cli) {
        List<List<String>> options = GenerateMarkdownHelpCommand.getOptionsAsStrings(this.injector, true);
        StringBuilder content = new StringBuilder();
        for (List<String> row : options) {
            boolean first = true;
            for (String cell : row) {
                if (first) {
                    first = false;
                    content.append("| ");
                } else {
                    content.append(" | ");
                }
                content.append(cell);
            }
            content.append(" |\n");
        }
        System.out.println(content.toString());
        return CommandOutcome.succeeded();
    }
}

