/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.utils;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JulPatternFormatter
extends Formatter {
    private final String pattern;
    private Date dat = new Date();

    public JulPatternFormatter(String pattern) {
        assert (!Strings.isNullOrEmpty((String)pattern));
        this.pattern = pattern;
    }

    @Override
    public String format(LogRecord record) {
        String throwable;
        this.dat.setTime(record.getMillis());
        StringBuilder source = new StringBuilder();
        String scn = record.getSourceClassName();
        String logName = record.getLoggerName();
        if (!Strings.isNullOrEmpty((String)scn)) {
            source.append(scn);
            String smn = record.getSourceMethodName();
            if (!Strings.isNullOrEmpty((String)smn)) {
                source.append(" ");
                source.append(smn);
            }
        } else {
            source.append(logName);
        }
        String message = this.formatMessage(record);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                pw.println();
                record.getThrown().printStackTrace(pw);
            }
            throwable = sw.toString();
        } else {
            throwable = "";
        }
        return String.format(this.pattern, this.dat, source, this.filterLogName(logName), record.getLevel().getLocalizedName(), message, throwable);
    }

    protected String filterLogName(String logName) {
        return logName;
    }
}

