/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.utils;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.FileSystem;

public class SystemPath
implements Iterable<File> {
    private final StringBuilder content = new StringBuilder();
    private final List<File> elements = new LinkedList<File>();

    public String toString() {
        return this.content.toString();
    }

    public void add(String path) {
        if (!Strings.isNullOrEmpty((String)path)) {
            if (this.content.length() > 0) {
                this.content.append(File.pathSeparator);
            }
            this.content.append(path);
            this.elements.add(FileSystem.convertStringToFile((String)path));
        }
    }

    public void add(File path) {
        if (path != null) {
            if (this.content.length() > 0) {
                this.content.append(File.pathSeparator);
            }
            String absPath = path.getAbsolutePath();
            this.content.append(absPath);
            this.elements.add(path);
        }
    }

    public void addEntries(SystemPath paths) {
        if (paths != null) {
            if (paths.content.length() > 0) {
                if (this.content.length() > 0) {
                    this.content.append(File.pathSeparator);
                }
                this.content.append((CharSequence)paths.content);
            }
            this.elements.addAll(paths.elements);
        }
    }

    public void addEntries(String paths) {
        if (paths != null) {
            for (String entry : paths.split(Pattern.quote(File.pathSeparator))) {
                this.add(entry);
            }
        }
    }

    public List<File> toFileList() {
        return Collections.unmodifiableList(this.elements);
    }

    public List<String> toFilenameList() {
        return Collections.unmodifiableList(Lists.transform(this.elements, it -> it.getAbsolutePath()));
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void clear() {
        this.content.setLength(0);
        this.elements.clear();
    }

    @Override
    public Iterator<File> iterator() {
        return Collections.unmodifiableList(this.elements).iterator();
    }
}

