/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.bootiqueapp.utils;

import com.google.common.base.Strings;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class SystemProperties {
    private SystemProperties() {
    }

    @Pure
    @Inline(value="getValue($1, null)")
    public static String getValue(String name) {
        return SystemProperties.getValue(name, null);
    }

    @Pure
    public static String getValue(String name, String defaultValue) {
        if (!Strings.isNullOrEmpty((String)name)) {
            String value;
            try {
                value = System.getProperty(name, null);
                if (!Strings.isNullOrEmpty((String)value)) {
                    return value;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                value = System.getenv(name);
                if (!Strings.isNullOrEmpty((String)value)) {
                    return value;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String bqName = "bq." + name;
            try {
                value = System.getProperty(bqName, null);
                if (!Strings.isNullOrEmpty((String)value)) {
                    return value;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                value = System.getenv(bqName);
                if (!Strings.isNullOrEmpty((String)value)) {
                    return value;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

