/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.eclipseextensions;

import io.sarl.apputils.uiextensions.UiExtensionsPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public final class Extensions {
    private Extensions() {
    }

    public static <T> Stream<T> getExtensions(String pluginId, String extensionId, String fieldName, Class<T> extensionType) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, extensionId);
        if (extensionPoint != null) {
            return Arrays.asList(extensionPoint.getConfigurationElements()).stream().map(element -> {
                try {
                    Object obj = element.createExecutableExtension(fieldName);
                    if (obj != null && extensionType.isInstance(obj)) {
                        return extensionType.cast(obj);
                    }
                    UiExtensionsPlugin plugin = UiExtensionsPlugin.getDefault();
                    IStatus status = plugin.createStatus(4, "Cannot instance extension point: " + element.getName());
                    plugin.getLog().log(status);
                }
                catch (CoreException e) {
                    UiExtensionsPlugin plugin = UiExtensionsPlugin.getDefault();
                    IStatus status = plugin.createStatus(4, (Throwable)e);
                    plugin.getLog().log(status);
                }
                return null;
            }).filter(it -> it != null);
        }
        return Collections.emptyList().stream();
    }

    public static Stream<IConfigurationElement> getExtensions(String pluginId, String extensionId) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, extensionId);
        if (extensionPoint != null) {
            return Arrays.asList(extensionPoint.getConfigurationElements()).stream();
        }
        return Collections.emptyList().stream();
    }
}

