/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.eclipseextensions.buildpath;

import io.sarl.apputils.eclipseextensions.buildpath.NameSegmentClasspathEntryComparator;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public abstract class AbstractSARLBasedClasspathContainer
implements IClasspathContainer {
    private IClasspathEntry[] entries;
    private final IPath containerPath;
    private IJavaProject project;
    private final Comparator<IClasspathEntry> entryComparator;

    public AbstractSARLBasedClasspathContainer(IPath containerPath, IJavaProject javaProject, Comparator<IClasspathEntry> entryComparator) {
        this.containerPath = containerPath;
        this.project = javaProject;
        this.entryComparator = entryComparator == null ? NameSegmentClasspathEntryComparator.getSingleton() : entryComparator;
    }

    protected Comparator<IClasspathEntry> getClasspathEntryComparator() {
        return this.entryComparator;
    }

    protected boolean isModular() {
        try {
            if (JavaRuntime.isModularProject((IJavaProject)this.project)) {
                return true;
            }
            IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)this.project);
            if (vm == null) {
                vm = JavaRuntime.getDefaultVMInstall();
            }
            return JavaRuntime.isModularJava((IVMInstall)vm);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final Set<String> getBundleDependencies() {
        TreeSet<String> bundles = new TreeSet<String>();
        this.updateBundleList(bundles);
        return bundles;
    }

    protected abstract void updateBundleList(Set<String> var1);

    public final synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.entries == null) {
            TreeSet<IClasspathEntry> newEntries = new TreeSet<IClasspathEntry>(this.getClasspathEntryComparator());
            this.updateClasspathEntries(newEntries);
            this.entries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        }
        return this.entries;
    }

    protected abstract void updateClasspathEntries(Set<IClasspathEntry> var1);

    public synchronized void reset() {
        this.entries = null;
    }

    public IPath getPath() {
        return this.containerPath;
    }
}

