/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.eclipseextensions.buildpath;

import java.util.Comparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

public class NameSegmentClasspathEntryComparator
implements Comparator<IClasspathEntry> {
    private static NameSegmentClasspathEntryComparator singleton;

    public static NameSegmentClasspathEntryComparator getSingleton() {
        if (singleton == null) {
            singleton = new NameSegmentClasspathEntryComparator();
        }
        return singleton;
    }

    @Override
    public int compare(IClasspathEntry entry1, IClasspathEntry entry2) {
        int segs2;
        if (entry1 == entry2) {
            return 0;
        }
        if (entry1 == null) {
            return Integer.MAX_VALUE;
        }
        if (entry2 == null) {
            return Integer.MIN_VALUE;
        }
        IPath path1 = entry1.getPath();
        IPath path2 = entry2.getPath();
        int segs1 = path1.segmentCount();
        int segs = segs1 <= (segs2 = path2.segmentCount()) ? segs1 : segs2;
        for (int i = 0; i < segs; ++i) {
            String seg2;
            String seg1 = path1.segment(i);
            int cmp = seg1.compareTo(seg2 = path2.segment(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(segs1, segs2);
    }
}

