/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.eclipseextensions.buildpath;

import java.util.Comparator;
import org.eclipse.core.runtime.IPath;

public class SARLPathComparator
implements Comparator<IPath> {
    private static SARLPathComparator singleton;
    private static final int CODE_SECTION = 0;
    private static final int TEST_SECTION = 200;
    private static final int INTEGRATION_TEST_SECTION = 400;
    private static final int GENERATED_SOURCE_SECTION = 600;
    private static final int SARL_SUBSECTION = 0;
    private static final int CODE_SUBSECTION = 20;
    private static final int RESOURCE_SUBSECTION = 40;

    public static SARLPathComparator getSingleton() {
        if (singleton == null) {
            singleton = new SARLPathComparator();
        }
        return singleton;
    }

    @Override
    public int compare(IPath path1, IPath path2) {
        int class2;
        if (path1 == path2) {
            return 0;
        }
        if (path1 == null) {
            return Integer.MIN_VALUE;
        }
        if (path2 == null) {
            return Integer.MAX_VALUE;
        }
        int class1 = SARLPathComparator.categorizes(path1);
        if (class1 != (class2 = SARLPathComparator.categorizes(path2))) {
            return class1 - class2;
        }
        String name1 = path1.toPortableString();
        String name2 = path2.toPortableString();
        return name1.compareTo(name2);
    }

    public static int categorizes(IPath path) {
        assert (path != null);
        int cnt = path.segmentCount();
        if (cnt >= 2) {
            String segment0 = path.segment(cnt - 2);
            if (cnt >= 3 && "src".equals(path.segment(cnt - 3))) {
                if ("test".equals(segment0)) {
                    return SARLPathComparator.subcategorizes(200, path);
                }
                if ("it".equals(segment0)) {
                    return SARLPathComparator.subcategorizes(400, path);
                }
            } else if ("generated-sources".equals(segment0)) {
                return 600;
            }
        }
        return SARLPathComparator.subcategorizes(0, path);
    }

    private static int subcategorizes(int section, IPath path) {
        int cnt = path.segmentCount();
        if (cnt >= 0) {
            String lastSegment = path.segment(cnt - 1);
            if ("sarl".equals(lastSegment)) {
                return section + 0;
            }
            if ("resources".equals(lastSegment)) {
                return section + 40;
            }
        }
        return section + 20;
    }
}

