/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.eclipseextensions.sreinstall;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.EclipseExtensionsPlugin;
import io.sarl.apputils.eclipseextensions.sreinstall.Messages;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractSREInstallPage
extends WizardPage {
    private String[] existingNames;
    private IStatus status = EclipseExtensionsPlugin.getDefault().createOkStatus();

    protected AbstractSREInstallPage(String pageName) {
        super(pageName);
    }

    protected AbstractSREInstallPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public abstract boolean performFinish();

    public boolean performCancel() {
        return true;
    }

    public abstract void initialize(ISREInstall var1);

    public abstract ISREInstall createSelection(String var1);

    protected IStatus validateNameAgainstOtherSREs(String name) {
        IStatus nameStatus = EclipseExtensionsPlugin.getDefault().createOkStatus();
        if (this.isDuplicateName(name)) {
            nameStatus = EclipseExtensionsPlugin.getDefault().createStatus(4, 16, Messages.SREInstallWizard_0);
        } else {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (!status.isOK()) {
                nameStatus = EclipseExtensionsPlugin.getDefault().createStatus(4, 16, MessageFormat.format(Messages.SREInstallWizard_1, status.getMessage()));
            }
        }
        return nameStatus;
    }

    protected void setPageStatus(IStatus status) {
        this.status = status == null ? EclipseExtensionsPlugin.getDefault().createOkStatus() : status;
    }

    private boolean isDuplicateName(String name) {
        if (this.existingNames != null) {
            String newName = Strings.nullToEmpty((String)name);
            for (String existingName : this.existingNames) {
                if (!newName.equals(existingName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setExistingNames(String ... names) {
        this.existingNames = names;
        for (int i = 0; i < this.existingNames.length; ++i) {
            this.existingNames[i] = Strings.nullToEmpty((String)this.existingNames[i]);
        }
    }

    public IWizardPage getNextPage() {
        return null;
    }

    protected void updatePageStatus() {
        if (this.status.isOK()) {
            this.setMessage(null, 0);
        } else {
            switch (this.status.getSeverity()) {
                case 4: {
                    this.setMessage(this.status.getMessage(), 3);
                    break;
                }
                case 1: {
                    this.setMessage(this.status.getMessage(), 1);
                    break;
                }
                case 2: {
                    this.setMessage(this.status.getMessage(), 2);
                    break;
                }
            }
        }
        this.setPageComplete(this.status.isOK() || this.status.getSeverity() == 1);
    }
}

