/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.eclipseextensions.sreprovider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ISREInstall
extends Cloneable {
    public static final int CODE_GENERAL = 1;
    public static final int CODE_LIBRARY_LOCATION = 2;
    public static final int CODE_SARL_VERSION = 4;
    public static final int CODE_MAIN_CLASS = 8;
    public static final int CODE_NAME = 16;
    public static final int CODE_SOURCE = 32;

    public ISREInstall clone();

    public ISREInstall copy(String var1);

    public String getId();

    public String getName();

    public String getNameNoDefault();

    public String getMainClass();

    public String getBootstrap();

    public String getLocation();

    public String getMinimalSARLVersion();

    public String getMaximalSARLVersion();

    public List<IRuntimeClasspathEntry> getClassPathEntries();

    public IPath getPreferredClassPathContainerPath();

    public Map<String, String> getAvailableCommandLineOptions();

    public String getSREArguments();

    public String getJVMArguments();

    public Map<String, String> getVMSpecificAttributesMap();

    public void setName(String var1);

    public void setClassPathEntries(List<IRuntimeClasspathEntry> var1);

    default public void setClassPathEntries(Iterable<IRuntimeClasspathEntry> libraries) {
        ArrayList<IRuntimeClasspathEntry> list;
        if (libraries == null) {
            list = null;
        } else if (libraries instanceof List) {
            list = (ArrayList<IRuntimeClasspathEntry>)libraries;
        } else {
            TreeSet<String> added = new TreeSet<String>();
            list = new ArrayList<IRuntimeClasspathEntry>();
            for (IRuntimeClasspathEntry cpe : libraries) {
                String location = cpe.getLocation();
                if (!1.$assertionsDisabled && location == null) {
                    throw new AssertionError();
                }
                if (!added.add(location)) continue;
                list.add(cpe);
            }
        }
        this.setClassPathEntries((List<IRuntimeClasspathEntry>)list);
    }

    public void setMinimalSARLVersion(String var1);

    public void setMaximalSARLVersion(String var1);

    public void setMainClass(String var1);

    public void setBootstrap(String var1);

    public void setVMSpecificAttributesMap(Map<String, String> var1);

    public void getAsXML(Document var1, Element var2) throws IOException;

    public void setFromXML(Element var1) throws IOException;

    default public IStatus getValidity() {
        return this.getValidity(0);
    }

    public IStatus getValidity(int var1);

    public IStatus revalidate();

    public void setNotify(boolean var1);

    public boolean getNotify();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

