/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.uiextensions;

import io.sarl.apputils.uiextensions.UiExtensionsPlugin;
import io.sarl.apputils.uiextensions.Utilities;
import io.sarl.apputils.uiextensions.classpath.JavaClasspathParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class Bundles {
    public static final String[] BIN_FOLDERS = new String[]{"target/classes", "bin"};
    public static final String[] SRC_FOLDERS = new String[]{"src/main/java", "src/main/sarl", "src"};
    private static final String SOURCE_SUFIX = ".source";
    private static final String JAVADOC_SUFIX = ".javadoc";
    private static final String JAR_EXTENSION = "jar";
    private static final String DOT_JAR_EXTENSION = ".jar";
    private static final String ROOT_NAME = "/";
    private static final String DEFAULT_PATH_TO_CLASSES_IN_MAVEN_PROJECT = "target/classes";

    private Bundles() {
    }

    protected static Set<BundleDependency> createBundleDependencySet() {
        return new TreeSet<BundleDependency>(new Comparator<BundleDependency>(){

            @Override
            public int compare(BundleDependency o1, BundleDependency o2) {
                return o1.getBundle().getSymbolicName().compareTo(o2.getBundle().getSymbolicName());
            }
        });
    }

    public static IPath getSourceBundlePath(Bundle bundle, IPath bundleLocation) {
        IPath sourcesPath = null;
        try {
            IPath srcFolderPath = Bundles.getSourceRootProjectFolderPath(bundle);
            if (srcFolderPath == null) {
                String symbolicName;
                String binaryJarName;
                String sourceJarName;
                IPath bundlesParentFolder = bundleLocation.removeLastSegments(1);
                IPath potentialSourceJar = bundlesParentFolder.append(sourceJarName = (binaryJarName = bundleLocation.lastSegment()).replace(symbolicName = bundle.getSymbolicName(), symbolicName.concat(SOURCE_SUFIX)));
                if (potentialSourceJar.toFile().exists()) {
                    sourcesPath = potentialSourceJar;
                }
            } else {
                sourcesPath = srcFolderPath;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return sourcesPath;
    }

    private static IPath getBinFolderPath(Bundle bundle) {
        for (String binFolder : BIN_FOLDERS) {
            URL binFolderURL = FileLocator.find((Bundle)bundle, (IPath)Path.fromPortableString((String)binFolder), null);
            if (binFolderURL == null) continue;
            try {
                URL binFolderFileURL = FileLocator.toFileURL((URL)binFolderURL);
                return new Path(binFolderFileURL.getPath()).makeAbsolute();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static IPath getSourceRootProjectFolderPath(Bundle bundle) {
        for (String srcFolder : SRC_FOLDERS) {
            IPath relPath = Path.fromPortableString((String)srcFolder);
            URL srcFolderURL = FileLocator.find((Bundle)bundle, (IPath)relPath, null);
            if (srcFolderURL == null) continue;
            try {
                URL srcFolderFileURL = FileLocator.toFileURL((URL)srcFolderURL);
                IPath absPath = new Path(srcFolderFileURL.getPath()).makeAbsolute();
                absPath = absPath.removeLastSegments(relPath.segmentCount());
                return absPath;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static IPath getBundlePath(Bundle bundle) {
        Optional opt;
        IPath path = Bundles.getBinFolderPath(bundle);
        if (path == null && (opt = FileLocator.getBundleFileLocation((Bundle)bundle)).isPresent()) {
            path = new Path(((File)opt.get()).getAbsolutePath());
        }
        return path;
    }

    public static IPath getJavadocBundlePath(Bundle bundle, IPath bundleLocation) {
        IPath sourcesPath = null;
        try {
            IPath srcFolderPath = Bundles.getSourceRootProjectFolderPath(bundle);
            if (srcFolderPath == null) {
                String symbolicName;
                String binaryJarName;
                String sourceJarName;
                IPath bundlesParentFolder = bundleLocation.removeLastSegments(1);
                IPath potentialSourceJar = bundlesParentFolder.append(sourceJarName = (binaryJarName = bundleLocation.lastSegment()).replace(symbolicName = bundle.getSymbolicName(), symbolicName.concat(JAVADOC_SUFIX)));
                if (potentialSourceJar.toFile().exists()) {
                    sourcesPath = potentialSourceJar;
                }
            } else {
                sourcesPath = srcFolderPath;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return sourcesPath;
    }

    public static IBundleDependencies resolveBundleDependencies(Bundle bundle) {
        return Bundles.resolveBundleDependencies(bundle, null);
    }

    public static IBundleDependencies resolveBundleDependencies(Bundle bundle, Utilities.BundleURLMappings javadocURLs) {
        Utilities.BundleURLMappings docMapping = javadocURLs == null ? new Utilities.SARLBundleJavadocURLMappings() : javadocURLs;
        return new BundleDependencies(bundle, null, null, docMapping);
    }

    public static IBundleDependencies resolveBundleDependenciesWithFilter(Bundle bundle, String ... directDependencies) {
        return Bundles.resolveBundleDependenciesWithFilter(bundle, (Utilities.BundleURLMappings)null, directDependencies);
    }

    public static IBundleDependencies resolveBundleDependenciesWithFilter(Bundle bundle, Utilities.BundleURLMappings javadocURLs, String ... directDependencies) {
        Utilities.BundleURLMappings docMapping = javadocURLs == null ? new Utilities.SARLBundleJavadocURLMappings() : javadocURLs;
        List<String> deps = directDependencies == null || directDependencies.length == 0 ? null : Arrays.asList(directDependencies);
        return new BundleDependencies(bundle, deps, null, docMapping);
    }

    public static IBundleDependencies resolveBundleDependenciesWithExtras(Bundle bundle, String ... extraDependencies) {
        return Bundles.resolveBundleDependenciesWithExtras(bundle, (Utilities.BundleURLMappings)null, extraDependencies);
    }

    public static IBundleDependencies resolveBundleDependenciesWithExtras(Bundle bundle, Utilities.BundleURLMappings javadocURLs, String ... extraDependencies) {
        Utilities.BundleURLMappings docMapping = javadocURLs == null ? new Utilities.SARLBundleJavadocURLMappings() : javadocURLs;
        List<String> deps = extraDependencies == null || extraDependencies.length == 0 ? null : Arrays.asList(extraDependencies);
        return new BundleDependencies(bundle, null, deps, docMapping);
    }

    public static interface IBundleDependencies {
        public String getBundleSymbolicName();

        public IPath getBundleBinaryPath();

        public Version getBundleVersion();

        public Iterable<String> getDirectSymbolicNames();

        public Iterable<IClasspathEntry> getDirectClasspathEntries();

        public Iterable<IRuntimeClasspathEntry> getDirectRuntimeClasspathEntries();

        public Set<BundleDependency> getDirectDependencies();

        public Iterable<String> getTransitiveSymbolicNames(boolean var1);

        public Iterable<IClasspathEntry> getTransitiveClasspathEntries(boolean var1);

        public Iterable<IRuntimeClasspathEntry> getTransitiveRuntimeClasspathEntries(boolean var1);

        public Iterable<BundleDependency> getTransitiveDependencies(boolean var1);
    }

    private static class BundleDependencies
    implements IBundleDependencies {
        private final Bundle bundle;
        private final Collection<String> directDependencies;
        private final Collection<String> extraDependencies;
        private final Utilities.BundleURLMappings javadocURLs;
        private IPath binaryBundlePath;
        private Map<Bundle, DependencyDefinition> bundleDependencies;

        BundleDependencies(Bundle bundle, Collection<String> directDependencies, Collection<String> extraDependencies, Utilities.BundleURLMappings javadocURLs) {
            assert (bundle != null);
            this.bundle = bundle;
            this.directDependencies = directDependencies;
            this.extraDependencies = extraDependencies;
            this.javadocURLs = javadocURLs;
        }

        private Map<Bundle, DependencyDefinition> getBundleDependencies() {
            if (this.bundleDependencies == null) {
                this.bundleDependencies = new TreeMap<Bundle, DependencyDefinition>(new Comparator<Bundle>(this){

                    @Override
                    public int compare(Bundle o1, Bundle o2) {
                        return o1.getSymbolicName().compareTo(o2.getSymbolicName());
                    }
                });
            }
            return this.bundleDependencies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DependencyDefinition getBundleDependencies(Bundle bundle) {
            Map<Bundle, DependencyDefinition> repository;
            Map<Bundle, DependencyDefinition> map = repository = this.getBundleDependencies();
            synchronized (map) {
                return repository.get(bundle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setBundleDependencies(Bundle bundle, Set<BundleDependency> cpEntries, boolean overwrite) {
            Map<Bundle, DependencyDefinition> repository;
            Map<Bundle, DependencyDefinition> map = repository = this.getBundleDependencies();
            synchronized (map) {
                if (overwrite || !repository.containsKey(bundle)) {
                    repository.put(bundle, new DependencyDefinition(bundle.getVersion(), cpEntries));
                } else {
                    DependencyDefinition dependencySet = repository.get(bundle);
                    assert (dependencySet != null);
                    dependencySet.setVersion(bundle.getVersion());
                    dependencySet.addDependencies(cpEntries);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToBundleDependencies(Bundle bundle, BundleDependency dependency) {
            Map<Bundle, DependencyDefinition> repository;
            Map<Bundle, DependencyDefinition> map = repository = this.getBundleDependencies();
            synchronized (map) {
                DependencyDefinition dependencySet = repository.get(bundle);
                if (dependencySet == null) {
                    repository.put(bundle, new DependencyDefinition(bundle.getVersion(), Collections.singletonList(dependency)));
                } else {
                    dependencySet.addDependencies(Collections.singletonList(dependency));
                }
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            DependencyDefinition dependencies = this.getDependencyDefinition();
            if (dependencies != null) {
                this.toDependencyTree(buf, new String(), new String(), this.bundle, false, dependencies.getDependencies());
            }
            return buf.toString();
        }

        private void toDependencyTree(StringBuilder builder, String indent1, String indent2, Bundle current, boolean isFragment, Collection<BundleDependency> dependencies) {
            builder.append(indent1);
            builder.append(current.getSymbolicName());
            if (isFragment) {
                builder.append(" (fragment)");
            }
            builder.append("\n");
            for (BundleDependency dependency : dependencies) {
                DependencyDefinition subdependencies;
                if (Objects.equals(current.getSymbolicName(), dependency.getBundle().getSymbolicName()) || (subdependencies = this.getBundleDependencies(dependency.getBundle())) == null) continue;
                this.toDependencyTree(builder, indent2 + "|- ", indent2 + "   ", dependency.getBundle(), dependency.isFragment(), subdependencies.getDependencies());
            }
        }

        @Override
        public IPath getBundleBinaryPath() {
            if (this.binaryBundlePath == null) {
                this.getDependencyDefinition();
            }
            return this.binaryBundlePath;
        }

        @Override
        public Iterable<String> getDirectSymbolicNames() {
            return () -> new SymbolicNameIterator(this, this.getDirectDependencies());
        }

        @Override
        public Iterable<IClasspathEntry> getDirectClasspathEntries() {
            return () -> new ClasspathEntryIterator(this, this.getDirectDependencies());
        }

        @Override
        public Iterable<IRuntimeClasspathEntry> getDirectRuntimeClasspathEntries() {
            return () -> new RuntimeClasspathEntryIterator(this, this.getDirectDependencies());
        }

        @Override
        public Iterable<String> getTransitiveSymbolicNames(boolean includeFragments) {
            return () -> new SymbolicNameIterator(this, this.getTransitiveDependencies(includeFragments));
        }

        @Override
        public Iterable<IClasspathEntry> getTransitiveClasspathEntries(boolean includeFragments) {
            return () -> new ClasspathEntryIterator(this, this.getTransitiveDependencies(includeFragments));
        }

        @Override
        public Iterable<IRuntimeClasspathEntry> getTransitiveRuntimeClasspathEntries(boolean includeFragments) {
            return () -> new RuntimeClasspathEntryIterator(this, this.getTransitiveDependencies(includeFragments));
        }

        private DependencyDefinition getDependencyDefinition() {
            DependencyDefinition dependencies = this.getBundleDependencies(this.bundle);
            if (dependencies == null) {
                IPath bundlePath = Bundles.getBundlePath(this.bundle);
                if (bundlePath.toFile().isDirectory()) {
                    IPath bundleSourcePath;
                    IPath outputFolder = bundleSourcePath = Bundles.getSourceBundlePath(this.bundle, bundlePath);
                    if (!bundlePath.equals((Object)bundleSourcePath)) {
                        outputFolder = Path.fromPortableString((String)bundleSourcePath.toPortableString().concat(Bundles.DEFAULT_PATH_TO_CLASSES_IN_MAVEN_PROJECT));
                    }
                    URL bundleURL = null;
                    try {
                        bundleURL = new URI("file://" + bundleSourcePath.toPortableString()).toURL();
                    }
                    catch (Exception e) {
                        return null;
                    }
                    IPath classpathOutputFolder = this.readDotClasspathAndReferencestoClasspath(null, this.bundle, bundleURL);
                    if (classpathOutputFolder != null) {
                        outputFolder = classpathOutputFolder;
                    }
                    this.binaryBundlePath = outputFolder;
                } else {
                    this.binaryBundlePath = bundlePath;
                }
                IClasspathEntry cpEntry = Utilities.newLibraryEntry(this.bundle, this.binaryBundlePath, null);
                Set<BundleDependency> cpEntries = Bundles.createBundleDependencySet();
                BundleDependencies.updateBundleClassPath(this.bundle, cpEntry, cpEntries);
                if (this.extraDependencies != null) {
                    for (String extraBundleName : this.extraDependencies) {
                        Bundle extraBundle = Platform.getBundle((String)extraBundleName);
                        if (extraBundle == null) continue;
                        BundleDependencies.updateBundleClassPath(extraBundle, cpEntry, cpEntries);
                    }
                }
                this.setBundleDependencies(this.bundle, cpEntries, true);
                this.extractAllBundleDependencies(this.bundle, true);
                dependencies = this.getBundleDependencies(this.bundle);
            }
            return dependencies;
        }

        @Override
        public Version getBundleVersion() {
            DependencyDefinition dependencies = this.getDependencyDefinition();
            if (dependencies == null) {
                return null;
            }
            return dependencies.getVersion();
        }

        @Override
        public String getBundleSymbolicName() {
            return this.bundle.getSymbolicName();
        }

        @Override
        public Set<BundleDependency> getDirectDependencies() {
            DependencyDefinition dependencies = this.getDependencyDefinition();
            if (dependencies == null) {
                return null;
            }
            return Collections.unmodifiableSet(dependencies.getDependencies());
        }

        @Override
        public Iterable<BundleDependency> getTransitiveDependencies(boolean includeFragments) {
            DependencyDefinition dependencies = this.getDependencyDefinition();
            if (dependencies == null) {
                return Collections.emptyList();
            }
            return () -> new TransitiveDependencyIterator(dependencies.getDependencies(), includeFragments);
        }

        private static BundleDependency updateBundleClassPath(Bundle bundle, IClasspathEntry entry, Set<BundleDependency> entries) {
            assert (bundle != null);
            assert (entry != null);
            BundleDependency rootDep = new BundleDependency(bundle, entry, false);
            entries.add(rootDep);
            Bundle[] fragments = Platform.getFragments((Bundle)bundle);
            if (fragments != null && fragments.length > 0) {
                for (Bundle fragment : fragments) {
                    IClasspathEntry fragmentEntry = Utilities.newLibraryEntry(fragment, null, null);
                    entries.add(new BundleDependency(fragment, fragmentEntry, true));
                }
            }
            return rootDep;
        }

        private void extractAllBundleDependencies(Bundle bundle, boolean firstCall) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List bundleWires = bundleWiring.getRequiredWires(null);
            if (bundleWires != null) {
                for (BundleWire wire : bundleWires) {
                    Bundle dependency = wire.getProviderWiring().getBundle();
                    assert (dependency != null);
                    String dependencyInstallationPath = dependency.getLocation();
                    DependencyDefinition existingDependencyCPE = this.getBundleDependencies(dependency);
                    boolean validDependency = !(existingDependencyCPE != null && dependency.getVersion().compareTo(existingDependencyCPE.getVersion()) <= 0 || firstCall && this.directDependencies != null && !this.directDependencies.contains(dependency.getSymbolicName()));
                    if (!validDependency) continue;
                    URL u = null;
                    try {
                        u = FileLocator.resolve((URL)dependency.getEntry(Bundles.ROOT_NAME));
                    }
                    catch (IOException e) {
                        UiExtensionsPlugin plugin = UiExtensionsPlugin.getDefault();
                        IStatus status = plugin.createStatus(4, e);
                        plugin.getLog().log(status);
                        return;
                    }
                    if (dependencyInstallationPath.contains(Bundles.JAR_EXTENSION) || u.getProtocol().equals(Bundles.JAR_EXTENSION)) {
                        IClasspathEntry cpEntry = Utilities.newLibraryEntry(dependency, null, this.javadocURLs);
                        Set<BundleDependency> cpEntries = Bundles.createBundleDependencySet();
                        BundleDependency dep = BundleDependencies.updateBundleClassPath(dependency, cpEntry, cpEntries);
                        this.setBundleDependencies(dependency, cpEntries, false);
                        this.addToBundleDependencies(bundle, dep);
                    } else {
                        this.readDotClasspathAndReferencestoClasspath(bundle, dependency, u);
                    }
                    this.extractAllBundleDependencies(dependency, false);
                }
            }
        }

        private IPath readDotClasspathAndReferencestoClasspath(Bundle parent, Bundle bundle, URL bundleInstallURL) {
            IPath outputLocation = null;
            BundleDependency mainDependency = null;
            Set<BundleDependency> cpEntries = Bundles.createBundleDependencySet();
            Enumeration entries = bundle.getEntryPaths(Bundles.ROOT_NAME);
            String entry = null;
            while (entries.hasMoreElements()) {
                IStatus status;
                entry = (String)entries.nextElement();
                if (entry.contains(".classpath")) {
                    try {
                        IClasspathEntry copy;
                        IClasspathEntry[][] classpath = JavaClasspathParser.readFileEntriesWithException(bundle.getSymbolicName(), bundleInstallURL);
                        if (classpath[0].length <= 0) continue;
                        int outputLocationEntryIndex = -1;
                        for (int i = 0; outputLocationEntryIndex < 0 && i < classpath[0].length; ++i) {
                            IClasspathEntry outputLocationEntry = classpath[0][i];
                            if (outputLocationEntry.getContentKind() != 10) continue;
                            outputLocation = outputLocationEntry.getPath();
                            IPath sourcePath = outputLocationEntry.getSourceAttachmentPath();
                            if (sourcePath == null) {
                                IPath entryPath = outputLocationEntry.getPath();
                                outputLocationEntry = Utilities.newOutputClasspathEntry(bundle, entryPath, null);
                            }
                            mainDependency = new BundleDependency(bundle, outputLocationEntry, false);
                            cpEntries.add(mainDependency);
                            outputLocationEntryIndex = i;
                        }
                        if (outputLocationEntryIndex >= 0) {
                            copy = new IClasspathEntry[classpath[0].length - 1];
                            if (outputLocationEntryIndex > 0) {
                                System.arraycopy(classpath[0], 0, copy, 0, outputLocationEntryIndex);
                            }
                            if (outputLocationEntryIndex < classpath[0].length - 1) {
                                System.arraycopy(classpath[0], outputLocationEntryIndex + 1, copy, outputLocationEntryIndex, classpath[0].length - outputLocationEntryIndex - 1);
                            }
                        } else {
                            copy = classpath[0];
                        }
                        if (copy == null || ((IClasspathEntry[])copy).length <= 0) continue;
                        for (IClasspathEntry cpentry : copy) {
                            if (cpentry.getEntryKind() == 5 || cpentry.getEntryKind() == 3) continue;
                            cpEntries.add(new BundleDependency(bundle, cpentry, false));
                        }
                        continue;
                    }
                    catch (IOException | URISyntaxException | CoreException e) {
                        UiExtensionsPlugin plugin = UiExtensionsPlugin.getDefault();
                        status = plugin.createStatus(4, e);
                        plugin.getLog().log(status);
                        return null;
                    }
                }
                if (!entry.contains(Bundles.DOT_JAR_EXTENSION)) continue;
                try {
                    URL bundleJARfileFullURL = new URI(bundleInstallURL.toExternalForm().concat(Bundles.ROOT_NAME).concat(entry)).toURL();
                    File jarFile = Util.toLocalFile((URI)bundleJARfileFullURL.toURI(), null);
                    Path jarFilePath = new Path(jarFile.getAbsolutePath());
                    IClasspathEntry cpEntry = Utilities.newLibraryEntry(bundle, (IPath)jarFilePath, this.javadocURLs);
                    BundleDependencies.updateBundleClassPath(bundle, cpEntry, cpEntries);
                }
                catch (Exception e) {
                    UiExtensionsPlugin plugin = UiExtensionsPlugin.getDefault();
                    status = plugin.createStatus(4, e);
                    plugin.getLog().log(status);
                    return null;
                }
            }
            if (cpEntries.size() > 0) {
                this.setBundleDependencies(bundle, cpEntries, true);
                if (parent != null && mainDependency != null) {
                    this.addToBundleDependencies(parent, mainDependency);
                }
            } else if (parent != null) {
                mainDependency = new BundleDependency(bundle, Utilities.newOutputClasspathEntry(bundle, null, null), false);
                this.addToBundleDependencies(parent, mainDependency);
            }
            return outputLocation;
        }

        private class TransitiveDependencyIterator
        implements Iterator<BundleDependency> {
            private final boolean includeFragments;
            private final LinkedList<Iterator<BundleDependency>> iterators = new LinkedList();
            private final Set<String> repliedBundles = new TreeSet<String>();
            private Iterator<BundleDependency> currentIterator;
            private BundleDependency current;

            TransitiveDependencyIterator(Iterable<BundleDependency> dependencies, boolean includeFragments) {
                this.includeFragments = includeFragments;
                if (dependencies != null) {
                    this.iterators.add(dependencies.iterator());
                }
                this.searchForNextElement();
            }

            private void searchForNextElement() {
                this.current = null;
                while (this.current == null && !this.iterators.isEmpty()) {
                    if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                        this.currentIterator = null;
                        while (this.currentIterator == null & !this.iterators.isEmpty()) {
                            Iterator<BundleDependency> iterator = this.iterators.removeFirst();
                            if (!iterator.hasNext()) continue;
                            this.currentIterator = iterator;
                        }
                    }
                    while (this.current == null && this.currentIterator != null && this.currentIterator.hasNext()) {
                        BundleDependency dep = this.currentIterator.next();
                        if (this.repliedBundles.contains(dep.getBundle().getSymbolicName()) || !this.includeFragments && dep.isFragment()) continue;
                        this.current = dep;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public BundleDependency next() {
                Set<BundleDependency> depsdeps;
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                BundleDependency cur = this.current;
                DependencyDefinition deps = BundleDependencies.this.getBundleDependencies(cur.getBundle());
                if (deps != null && (depsdeps = deps.getDependencies()) != null) {
                    this.iterators.add(depsdeps.iterator());
                }
                this.repliedBundles.add(cur.getBundle().getSymbolicName());
                this.searchForNextElement();
                return cur;
            }
        }

        private class RuntimeClasspathEntryIterator
        implements Iterator<IRuntimeClasspathEntry> {
            private final Iterator<BundleDependency> iterator;

            RuntimeClasspathEntryIterator(BundleDependencies bundleDependencies, Iterable<BundleDependency> dependencies) {
                this.iterator = dependencies == null ? Collections.emptyList().iterator() : dependencies.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public IRuntimeClasspathEntry next() {
                BundleDependency dependency = this.iterator.next();
                return dependency.getRuntimeClassPathEntry();
            }
        }

        private class ClasspathEntryIterator
        implements Iterator<IClasspathEntry> {
            private final Iterator<BundleDependency> iterator;

            ClasspathEntryIterator(BundleDependencies bundleDependencies, Iterable<BundleDependency> dependencies) {
                this.iterator = dependencies == null ? Collections.emptyList().iterator() : dependencies.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public IClasspathEntry next() {
                BundleDependency dependency = this.iterator.next();
                return dependency.getClassPathEntry();
            }
        }

        private class SymbolicNameIterator
        implements Iterator<String> {
            private final Iterator<BundleDependency> iterator;

            SymbolicNameIterator(BundleDependencies bundleDependencies, Iterable<BundleDependency> dependencies) {
                this.iterator = dependencies == null ? Collections.emptyList().iterator() : dependencies.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                BundleDependency dependency = this.iterator.next();
                return dependency.getBundle().getSymbolicName();
            }
        }
    }

    private static class DependencyDefinition {
        private Version version;
        private final Set<BundleDependency> dependencies = Bundles.createBundleDependencySet();
        private final Set<String> dependencyIds = new TreeSet<String>();

        DependencyDefinition(Version version, Collection<BundleDependency> dependencies) {
            this.version = version;
            this.addDependencies(dependencies);
        }

        public void setVersion(Version version) {
            if (version != null) {
                this.version = version;
            }
        }

        public void addDependencies(Collection<BundleDependency> dependencies) {
            for (BundleDependency dependency : dependencies) {
                if (!this.dependencyIds.add(dependency.getBundle().getSymbolicName())) continue;
                this.dependencies.add(dependency);
            }
        }

        public Version getVersion() {
            return this.version;
        }

        public Set<BundleDependency> getDependencies() {
            return Collections.unmodifiableSet(this.dependencies);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("version=");
            buf.append(this.version);
            buf.append("; dependencies=");
            buf.append(this.dependencies.toString());
            return buf.toString();
        }
    }

    public static class BundleDependency {
        private final Bundle bundle;
        private final IClasspathEntry classpathEntry;
        private final boolean isFragment;
        private IRuntimeClasspathEntry runtimeClasspathEntry;

        BundleDependency(Bundle bundle, IClasspathEntry classPathEntry, boolean isFragment) {
            assert (bundle != null);
            assert (classPathEntry != null);
            this.bundle = bundle;
            this.classpathEntry = classPathEntry;
            this.isFragment = isFragment;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public IClasspathEntry getClassPathEntry() {
            return this.classpathEntry;
        }

        public IRuntimeClasspathEntry getRuntimeClassPathEntry() {
            if (this.classpathEntry != null && this.runtimeClasspathEntry == null) {
                this.runtimeClasspathEntry = new RuntimeClasspathEntry(this.classpathEntry);
            }
            return this.runtimeClasspathEntry;
        }

        public boolean isFragment() {
            return this.isFragment;
        }

        public String toString() {
            return this.bundle.getSymbolicName();
        }
    }
}

