/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.uiextensions;

import io.sarl.apputils.uiextensions.UiExtensionsPlugin;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public final class ProjectNatures {
    private ProjectNatures() {
    }

    public static IStatus addNatures(IProject project, IProgressMonitor monitor, String ... natureIdentifiers) {
        if (project != null && natureIdentifiers != null && natureIdentifiers.length > 0) {
            try {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(natureIdentifiers.length + 2));
                IProjectDescription description = project.getDescription();
                LinkedList<String> natures = new LinkedList<String>(Arrays.asList(description.getNatureIds()));
                for (String natureIdentifier : natureIdentifiers) {
                    if (natureIdentifier != null && natureIdentifier.length() > 0 && !natures.contains(natureIdentifier)) {
                        natures.add(0, natureIdentifier);
                    }
                    subMonitor.worked(1);
                }
                String[] newNatures = natures.toArray(new String[natures.size()]);
                IStatus status = ResourcesPlugin.getWorkspace().validateNatureSet(newNatures);
                subMonitor.worked(1);
                if (status.getCode() == 0) {
                    description.setNatureIds(newNatures);
                    project.setDescription(description, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                return status;
            }
            catch (CoreException exception) {
                return UiExtensionsPlugin.getDefault().createStatus(4, exception);
            }
        }
        return UiExtensionsPlugin.getDefault().createOkStatus();
    }
}

