/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.uiextensions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class UiExtensionsPlugin
extends Plugin {
    public static final String PLUGIN_ID = "io.sarl.apputils.uiextensions";
    private static UiExtensionsPlugin instance;

    public UiExtensionsPlugin() {
        UiExtensionsPlugin.setDefault(this);
    }

    public static void setDefault(UiExtensionsPlugin defaultInstance) {
        instance = defaultInstance;
    }

    public static UiExtensionsPlugin getDefault() {
        return instance;
    }

    public IStatus createStatus(int severity, int code, String message, Throwable cause) {
        String msg = message;
        if (msg == null || msg.length() == 0) {
            msg = cause.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = cause.getMessage();
            }
            if (msg == null || msg.length() == 0) {
                msg = cause.getClass().getSimpleName();
            }
        }
        if (cause != null) {
            StackTraceElement[] stackTraces;
            ArrayList<IStatus> childStatuses = new ArrayList<IStatus>();
            for (StackTraceElement stackTrace : stackTraces = cause.getStackTrace()) {
                IStatus status = this.createStatus(severity, stackTrace.toString());
                childStatuses.add(status);
            }
            IStatus[] children = new IStatus[childStatuses.size()];
            if (!childStatuses.isEmpty()) {
                childStatuses.toArray(children);
            }
            return new MultiStatus(PLUGIN_ID, code, children, msg, cause);
        }
        return new Status(severity, PLUGIN_ID, code, msg, cause);
    }

    public IStatus createStatus(int severity, Throwable cause) {
        return this.createStatus(severity, 0, null, cause);
    }

    public IStatus createStatus(int severity, int code, Throwable cause) {
        return this.createStatus(severity, code, null, cause);
    }

    public IStatus createStatus(int severity, String message) {
        return this.createStatus(severity, 0, message);
    }

    public IStatus createStatus(int severity, int code, String message) {
        return this.createStatus(severity, code, message, null);
    }

    public IStatus createOkStatus() {
        return Status.OK_STATUS;
    }
}

