/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.uiextensions;

import com.google.common.base.Strings;
import io.sarl.apputils.uiextensions.Bundles;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class Utilities {
    public static final String EMPTY_STRING = "";

    private Utilities() {
    }

    public static boolean isNested(IPath path, Iterator<IPath> rootPaths) {
        while (rootPaths.hasNext()) {
            IPath other = rootPaths.next();
            if (!other.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    public static Version parseVersion(String version) {
        if (!Strings.isNullOrEmpty((String)version)) {
            try {
                return Version.parseVersion((String)version);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static int compareVersionToRange(Version version, Version minVersion, Version maxVersion) {
        assert (minVersion == null || maxVersion == null || minVersion.compareTo(maxVersion) < 0);
        if (version == null) {
            return Integer.MIN_VALUE;
        }
        if (minVersion != null && Utilities.compareVersionsNoQualifier(version, minVersion) < 0) {
            return -1;
        }
        if (maxVersion != null && Utilities.compareVersionsNoQualifier(version, maxVersion) >= 0) {
            return 1;
        }
        return 0;
    }

    private static int compareVersionsNoQualifier(Version firstVersion, Version secondVersion) {
        if (firstVersion == secondVersion) {
            return 0;
        }
        int result = firstVersion.getMajor() - secondVersion.getMajor();
        if (result != 0) {
            return result;
        }
        result = firstVersion.getMinor() - secondVersion.getMinor();
        if (result != 0) {
            return result;
        }
        return firstVersion.getMicro() - secondVersion.getMicro();
    }

    public static <T> int compareTo(Comparable<T> object1, T object2) {
        if (object1 == object2) {
            return 0;
        }
        if (object1 == null) {
            return Integer.MIN_VALUE;
        }
        if (object2 == null) {
            return Integer.MAX_VALUE;
        }
        assert (object1 != null && object2 != null);
        return object1.compareTo(object2);
    }

    public static String getNameWithTypeParameters(IType type) {
        assert (type != null);
        String superName = type.getFullyQualifiedName('.');
        try {
            ITypeParameter[] typeParameters = type.getTypeParameters();
            if (typeParameters != null && typeParameters.length > 0) {
                StringBuffer buf = new StringBuffer(superName);
                buf.append('<');
                for (int k = 0; k < typeParameters.length; ++k) {
                    if (k != 0) {
                        buf.append(',').append(' ');
                    }
                    buf.append(typeParameters[k].getElementName());
                }
                buf.append('>');
                return buf.toString();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return superName;
    }

    public static IClasspathEntry newLibraryEntry(Bundle bundle, IPath precomputedBundlePath, BundleURLMappings javadocURLs) {
        IClasspathAttribute[] extraAttributes;
        assert (bundle != null);
        IPath bundlePath = precomputedBundlePath == null ? Bundles.getBundlePath(bundle) : precomputedBundlePath;
        IPath sourceBundlePath = Bundles.getSourceBundlePath(bundle, bundlePath);
        IPath javadocPath = Bundles.getJavadocBundlePath(bundle, bundlePath);
        if (javadocPath == null) {
            if (javadocURLs != null) {
                String url = javadocURLs.getURLForBundle(bundle);
                if (!Strings.isNullOrEmpty((String)url)) {
                    IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)url);
                    extraAttributes = new IClasspathAttribute[]{attr};
                } else {
                    extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
                }
            } else {
                extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
            }
        } else {
            IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocPath.makeAbsolute().toOSString());
            extraAttributes = new IClasspathAttribute[]{attr};
        }
        return JavaCore.newLibraryEntry((IPath)bundlePath, (IPath)sourceBundlePath, null, null, (IClasspathAttribute[])extraAttributes, (boolean)false);
    }

    public static IClasspathEntry newOutputClasspathEntry(Bundle bundle, IPath precomputedBundlePath, BundleURLMappings javadocURLs) {
        IClasspathAttribute[] extraAttributes;
        assert (bundle != null);
        IPath bundlePath = precomputedBundlePath == null ? Bundles.getBundlePath(bundle) : precomputedBundlePath;
        IPath sourceBundlePath = Bundles.getSourceBundlePath(bundle, bundlePath);
        IPath javadocPath = Bundles.getJavadocBundlePath(bundle, bundlePath);
        if (javadocPath == null) {
            if (javadocURLs != null) {
                String url = javadocURLs.getURLForBundle(bundle);
                if (!Strings.isNullOrEmpty((String)url)) {
                    IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)url);
                    extraAttributes = new IClasspathAttribute[]{attr};
                } else {
                    extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
                }
            } else {
                extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
            }
        } else {
            IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocPath.makeAbsolute().toOSString());
            extraAttributes = new IClasspathAttribute[]{attr};
        }
        return new ClasspathEntry(10, 1, bundlePath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, sourceBundlePath, null, null, false, null, false, extraAttributes);
    }

    public static boolean isGeneratedFolder(String folderName) {
        if (folderName != null) {
            IPath path = IPath.fromPortableString((String)folderName);
            return Utilities.isGeneratedFolder(path);
        }
        return false;
    }

    public static boolean isGeneratedFolder(IPath folderName) {
        if (folderName != null) {
            for (String segment : folderName.segments()) {
                if (!"src-gen".equals(segment) && !"generated-sources".equals(segment)) continue;
                return true;
            }
        }
        return false;
    }

    @FunctionalInterface
    public static interface BundleURLMappings {
        public String getURLForBundle(Bundle var1);
    }

    public static class SARLBundleJavadocURLMappings
    implements BundleURLMappings {
        private static final String SARL_PREFIX = "io.sarl.";
        private static final String WRAPPED_SARL_PREFIX = "wrapped.io.sarl.";

        @Override
        public String getURLForBundle(Bundle bundle) {
            String name = bundle.getSymbolicName();
            if (name.startsWith(SARL_PREFIX) || name.startsWith(WRAPPED_SARL_PREFIX)) {
                return "http://www.sarl.io/docs/api/";
            }
            return null;
        }
    }
}

