/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.apputils.uiextensions.classpath;

import io.sarl.apputils.uiextensions.UiExtensionsPlugin;
import io.sarl.apputils.uiextensions.Utilities;
import io.sarl.apputils.uiextensions.classpath.SarlDefaultClassPathProvider;
import io.sarl.lang.SARLConfig;
import io.sarl.lang.core.util.SarlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlClassPathDetector
implements IResourceProxyVisitor {
    private static final String[] CLASS_FILE_EXTENSIONS = new String[]{".class", ".Class", ".CLASS"};
    private static final String[] JAR_FILE_EXTENSIONS = new String[]{".jar", ".Jar", ".JAR"};
    private final SarlDefaultClassPathProvider defaultCPProvider;
    private final Map<IPath, List<IPath>> sourceFolders;
    private final List<IResource> classFiles;
    private final Set<IPath> jarFiles;
    private final IProject project;
    private IPath resultOutputFolder;
    private IClasspathEntry[] resultClasspath;
    private final IProgressMonitor monitor;
    private final IPath standardSarlSourceFolder;
    private final IPath testSarlSourceFolder;
    private final IPath generationSarlSourceFolder;

    public SarlClassPathDetector(IProject project, SarlDefaultClassPathProvider defaultCPProvider, IProgressMonitor monitor) throws CoreException {
        this.defaultCPProvider = defaultCPProvider;
        this.sourceFolders = new HashMap<IPath, List<IPath>>();
        this.jarFiles = new HashSet<IPath>(10);
        this.classFiles = new ArrayList<IResource>(100);
        this.project = project;
        this.resultClasspath = null;
        this.resultOutputFolder = null;
        this.standardSarlSourceFolder = Path.fromPortableString((String)"src/main/sarl");
        this.testSarlSourceFolder = Path.fromPortableString((String)"src/test/sarl");
        this.generationSarlSourceFolder = Path.fromPortableString((String)"src/main/generated-sources/sarl");
        IProgressMonitor mon = monitor;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        this.monitor = mon;
        this.detectClasspath();
    }

    @Pure
    public IPath getOutputLocation() {
        return this.resultOutputFolder;
    }

    @Pure
    public IClasspathEntry[] getClasspath() {
        if (this.resultClasspath == null) {
            return new IClasspathEntry[0];
        }
        return this.resultClasspath;
    }

    @Pure
    protected boolean isValidJavaCUName(String name) {
        return !JavaConventionsUtil.validateCompilationUnitName((String)name, (IJavaElement)JavaCore.create((IProject)this.project)).matches(4);
    }

    @Pure
    protected boolean isValidSarlCUName(String name) {
        return SarlUtils.hasFileExtension((String)name, (String[])SARLConfig.SARL_FILE_EXTENSIONS);
    }

    private static int computeOrderPriority(IPath path) {
        int len = path.segmentCount();
        if (len >= 2 && "generated-sources".equals(path.segment(len - 2))) {
            return 0;
        }
        if (len >= 1 && "sarl".equals(path.segment(len - 1))) {
            return 2;
        }
        return 1;
    }

    @Pure
    public Comparator<IClasspathEntry> getCPEntryComparator() {
        Collator collator = Collator.getInstance();
        return (e1, e2) -> {
            IPath p1 = e1.getPath();
            IPath p2 = e2.getPath();
            int priority1 = SarlClassPathDetector.computeOrderPriority(p1);
            int priority2 = SarlClassPathDetector.computeOrderPriority(p2);
            int cmp = priority2 - priority1;
            if (cmp != 0) {
                return cmp;
            }
            return collator.compare(p1.toString(), p2.toString());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectClasspath() throws CoreException {
        try {
            this.monitor.beginTask(NewWizardMessages.ClassPathDetector_operation_description, 4);
            this.project.accept((IResourceProxyVisitor)this, 0);
            this.monitor.worked(1);
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
            this.detectSourceFolders(cpEntries);
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.monitor.worked(1);
            IPath outputLocation = this.detectOutputFolder();
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.monitor.worked(1);
            this.detectLibraries(cpEntries, outputLocation);
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.monitor.worked(1);
            if (cpEntries.isEmpty() && this.classFiles.isEmpty()) {
                return;
            }
            this.defaultCPProvider.putDefaultClasspathEntriesIn(cpEntries);
            IClasspathEntry[] entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
            if (!JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)this.project), (IClasspathEntry[])entries, (IPath)outputLocation).isOK()) {
                return;
            }
            this.resultClasspath = entries;
            this.resultOutputFolder = outputLocation;
        }
        finally {
            this.monitor.done();
        }
    }

    protected void detectSourceFolders(List<IClasspathEntry> resEntries) {
        IClasspathEntry entry;
        IPath projectPath;
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Set<IPath> sourceFolderSet = this.sourceFolders.keySet();
        boolean generatedSourceFolderPresent = false;
        int nbCodeFolders = 0;
        for (IPath path : sourceFolderSet) {
            IClasspathEntry entry2 = this.createSourceFolderEntry(path);
            res.add(entry2);
            if (this.generationSarlSourceFolder.equals((Object)path.removeFirstSegments(0))) {
                generatedSourceFolderPresent = true;
                continue;
            }
            ++nbCodeFolders;
        }
        if (!generatedSourceFolderPresent) {
            projectPath = this.project.getFullPath();
            entry = this.createSourceFolderEntry(projectPath.append(this.generationSarlSourceFolder));
            res.add(entry);
        }
        if (nbCodeFolders == 0) {
            projectPath = this.project.getFullPath();
            entry = this.createSourceFolderEntry(projectPath.append(this.standardSarlSourceFolder));
            res.add(entry);
        }
        Collections.sort(res, this.getCPEntryComparator());
        resEntries.addAll(res);
    }

    private IClasspathEntry createSourceFolderEntry(IPath path) {
        ArrayList<IPath> excluded = new ArrayList<IPath>();
        for (IPath other : this.sourceFolders.keySet()) {
            if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
            IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
            excluded.add(pathToExclude);
        }
        IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
        return JavaCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
    }

    protected IPath detectOutputFolder() throws CoreException {
        HashSet<IPath> classFolders = new HashSet<IPath>();
        for (IResource resource : this.classFiles) {
            IFile file = (IFile)resource;
            IClassFileReader reader = null;
            try (InputStream content = file.getContents();){
                reader = ToolFactory.createDefaultClassFileReader((InputStream)content, (int)17);
            }
            catch (IOException exception) {
                throw new CoreException(UiExtensionsPlugin.getDefault().createStatus(4, exception));
            }
            if (reader == null) continue;
            char[] className = reader.getClassName();
            ISourceAttribute sourceAttribute = reader.getSourceFileAttribute();
            if (className == null || sourceAttribute == null || sourceAttribute.getSourceFileName() == null) continue;
            IPath packPath = file.getParent().getFullPath();
            int idx = CharOperation.lastIndexOf((char)'/', (char[])className) + 1;
            Path relPath = new Path(new String(className, 0, idx));
            IPath cuPath = relPath.append(new String(sourceAttribute.getSourceFileName()));
            IPath resPath = null;
            if (idx == 0) {
                resPath = packPath;
            } else {
                IPath folderPath = SarlClassPathDetector.getFolderPath(packPath, (IPath)relPath);
                if (folderPath != null) {
                    resPath = folderPath;
                }
            }
            if (resPath == null) continue;
            IPath path = this.findInSourceFolders(cuPath);
            if (path != null) {
                return resPath;
            }
            classFolders.add(resPath);
        }
        IPath projPath = this.project.getFullPath();
        if (this.sourceFolders.size() == 1 && classFolders.isEmpty() && this.sourceFolders.get(projPath) != null) {
            return projPath;
        }
        IPath path = projPath.append("target/classes");
        while (classFolders.contains(path)) {
            path = new Path(path.toString() + "1");
        }
        return path;
    }

    protected void detectLibraries(List<IClasspathEntry> cpEntries, IPath outputLocation) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Set<IPath> sourceFolderSet = this.sourceFolders.keySet();
        for (IPath path : this.jarFiles) {
            if (Utilities.isNested(path, sourceFolderSet.iterator()) || outputLocation != null && outputLocation.isPrefixOf(path)) continue;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
            res.add(entry);
        }
        Collections.sort(res, this.getCPEntryComparator());
        cpEntries.addAll(res);
    }

    @Pure
    protected IPath findInSourceFolders(IPath path) {
        for (Map.Entry<IPath, List<IPath>> entry : this.sourceFolders.entrySet()) {
            if (!entry.getValue().contains(path)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected static void addToMap(Map<IPath, List<IPath>> map, IPath folderPath, IPath relPath) {
        List<IPath> list = map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    protected static IPath getFolderPath(IPath packPath, IPath relpath) {
        IPath common;
        int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
        if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals((Object)relpath)) {
            return packPath.uptoSegment(remainingSegments);
        }
        return null;
    }

    protected void visitJavaCompilationUnit(IFile jfile) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)jfile);
        if (cu != null) {
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setSource(cu);
            parser.setFocalPosition(0);
            CompilationUnit root = (CompilationUnit)parser.createAST(null);
            PackageDeclaration packDecl = root.getPackage();
            IPath packPath = jfile.getParent().getFullPath();
            String cuName = jfile.getName();
            if (packDecl == null) {
                SarlClassPathDetector.addToMap(this.sourceFolders, packPath, (IPath)new Path(cuName));
            } else {
                Path relPath = new Path(packDecl.getName().getFullyQualifiedName().replace('.', '/'));
                IPath folderPath = SarlClassPathDetector.getFolderPath(packPath, (IPath)relPath);
                if (folderPath != null) {
                    SarlClassPathDetector.addToMap(this.sourceFolders, folderPath, relPath.append(cuName));
                }
            }
        }
    }

    private IPath findSarlSourceFolder(IPath path) {
        for (IPath sourceFolder : this.sourceFolders.keySet()) {
            if (!sourceFolder.isPrefixOf(path)) continue;
            return sourceFolder;
        }
        IPath projectPath = path.uptoSegment(1);
        IPath stdSarl = projectPath.append(this.standardSarlSourceFolder);
        if (stdSarl.isPrefixOf(path)) {
            return stdSarl;
        }
        IPath testSarl = projectPath.append(this.testSarlSourceFolder);
        if (testSarl.isPrefixOf(path)) {
            return testSarl;
        }
        return null;
    }

    protected void visitSarlCompilationUnit(IFile sfile) {
        IPath path = sfile.getFullPath();
        IPath sourceFolder = this.findSarlSourceFolder(path);
        if (sourceFolder != null) {
            SarlClassPathDetector.addToMap(this.sourceFolders, sourceFolder, path.removeFirstSegments(sourceFolder.segmentCount()));
        }
    }

    public boolean visit(IResourceProxy proxy) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            if (this.isValidJavaCUName(name)) {
                this.visitJavaCompilationUnit((IFile)proxy.requestResource());
            } else if (this.isValidSarlCUName(name)) {
                this.visitSarlCompilationUnit((IFile)proxy.requestResource());
            } else if (SarlUtils.hasFileExtension((String)name, (String[])CLASS_FILE_EXTENSIONS)) {
                this.classFiles.add(proxy.requestResource());
            } else if (SarlUtils.hasFileExtension((String)name, (String[])JAR_FILE_EXTENSIONS)) {
                this.jarFiles.add(proxy.requestFullPath());
            }
            return false;
        }
        return true;
    }
}

