/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.bootique.printconfig.commands;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.base.Strings;
import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.di.Injector;
import io.bootique.log.BootLogger;
import io.bootique.meta.application.CommandMetadata;
import io.bootique.meta.application.OptionMetadata;
import io.bootique.meta.config.ConfigMetadataNode;
import io.bootique.meta.module.ModulesMetadata;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import joptsimple.OptionSpec;
import org.arakhne.afc.bootique.printconfig.configs.Configs;
import org.arakhne.afc.vmutil.locale.Locale;

public class PrintConfigCommand
extends CommandWithMetadata {
    private static final String CLI_NAME = "printconfig";
    private static final char CLI_SHORTNAME = 'C';
    private static final String JSON_OPTION = "json";
    private static final String XML_OPTION = "xml";
    private static final String XML_ROOT_NAME = "configuration";
    private static final String JVM_KEY = "jvm";
    private static final String JAVA_CLASSPATH_KEY = "java.class.path";
    private static final String JAVA_MODULEPATH_KEY = "jdk.module.path";
    private static final String JAVA_UPGRADEPATH_KEY = "jdk.module.upgrade.path";
    private static final String JAVA_MODULEMAIN_KEY = "jdk.module.main";
    private static final String JAVA_MODULEMAINCLASS_KEY = "jdk.module.main.class";
    private static final int ERROR_CODE = 255;
    private final Provider<BootLogger> bootLogger;
    private final Provider<ModulesMetadata> modulesMetadata;
    private final Injector injector;

    public PrintConfigCommand(Provider<BootLogger> bootLogger, Provider<ModulesMetadata> modulesMetadata, Injector injector) {
        super(CommandMetadata.builder(PrintConfigCommand.class).description(Locale.getString((String)"COMMAND_DESCRIPTION", (Object[])new Object[]{JSON_OPTION, XML_OPTION})).name(CLI_NAME).shortName('C').addOption(OptionMetadata.builder((String)JSON_OPTION).description(Locale.getString((String)"JSON_DESCRIPTION", (Object[])new Object[0])).build()).addOption(OptionMetadata.builder((String)XML_OPTION).description(Locale.getString((String)"XML_DESCRIPTION", (Object[])new Object[0])).build()).build());
        this.bootLogger = bootLogger;
        this.modulesMetadata = modulesMetadata;
        this.injector = injector;
    }

    public CommandOutcome run(Cli cli) {
        String content;
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        this.extractJvmValues(values);
        this.extractConfigValues(values, Configs.extractConfigs((ModulesMetadata)this.modulesMetadata.get()));
        List options = cli.detectedOptions();
        String lastOpt = null;
        for (int i = options.size() - 1; lastOpt == null && i >= 0; --i) {
            OptionSpec opt = (OptionSpec)options.get(i);
            if (opt.options().contains(JSON_OPTION)) {
                lastOpt = JSON_OPTION;
                continue;
            }
            if (!opt.options().contains(XML_OPTION)) continue;
            lastOpt = XML_OPTION;
        }
        try {
            content = lastOpt == JSON_OPTION ? this.generateJson(values) : (lastOpt == XML_OPTION ? this.generateXml(values) : this.generateYaml(values));
        }
        catch (JsonProcessingException exception) {
            return CommandOutcome.failed((int)255, (String)exception.getLocalizedMessage(), (Throwable)exception);
        }
        ((BootLogger)this.bootLogger.get()).stdout(content);
        return CommandOutcome.succeeded();
    }

    protected void extractJvmValues(Map<String, Object> yaml) {
        TreeMap<String, Object> jvmValues = new TreeMap<String, Object>();
        try {
            Configs.defineScalar(jvmValues, JAVA_CLASSPATH_KEY, Strings.nullToEmpty((String)System.getProperty(JAVA_CLASSPATH_KEY)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Configs.defineScalar(jvmValues, JAVA_MODULEPATH_KEY, Strings.nullToEmpty((String)System.getProperty(JAVA_MODULEPATH_KEY)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Configs.defineScalar(jvmValues, JAVA_UPGRADEPATH_KEY, Strings.nullToEmpty((String)System.getProperty(JAVA_UPGRADEPATH_KEY)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Configs.defineScalar(jvmValues, JAVA_MODULEMAIN_KEY, Strings.nullToEmpty((String)System.getProperty(JAVA_MODULEMAIN_KEY)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Configs.defineScalar(jvmValues, JAVA_MODULEMAINCLASS_KEY, Strings.nullToEmpty((String)System.getProperty(JAVA_MODULEMAINCLASS_KEY)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!jvmValues.isEmpty()) {
            yaml.put(JVM_KEY, jvmValues);
        }
    }

    protected void extractConfigValues(Map<String, Object> yaml, List<ConfigMetadataNode> configs) {
        for (ConfigMetadataNode config : configs) {
            Configs.defineConfig(yaml, config, this.injector);
        }
    }

    protected String generateYaml(Map<String, Object> map) throws JsonProcessingException {
        YAMLFactory yamlFactory = new YAMLFactory();
        yamlFactory.configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map);
    }

    protected String generateJson(Map<String, Object> map) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map);
    }

    protected String generateXml(Map<String, Object> map) throws JsonProcessingException {
        XmlMapper mapper = new XmlMapper();
        return mapper.writerWithDefaultPrettyPrinter().withRootName(XML_ROOT_NAME).writeValueAsString(map);
    }
}

