/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.bootique.printconfig.configs;

import io.bootique.di.Injector;
import io.bootique.meta.MetadataNode;
import io.bootique.meta.config.ConfigMetadataNode;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Configs {
    private Configs() {
    }

    public static List<ConfigMetadataNode> extractConfigs(ModulesMetadata modulesMetadata) {
        List modules = modulesMetadata.getModules().stream().collect(Collectors.toList());
        return modules.stream().map(ModuleMetadata::getConfigs).flatMap(Collection::stream).sorted(Comparator.comparing(MetadataNode::getName)).collect(Collectors.toList());
    }

    public static void defineConfig(Map<String, Object> content, ConfigMetadataNode config, Injector injector) {
        assert (content != null);
        assert (config != null);
        Class type = (Class)config.getType();
        String sectionName = config.getName();
        Pattern setPattern = Pattern.compile("^set([A-Z])([a-zA-Z0-9]+)$");
        Object theConfig = null;
        for (Method setterMethod : type.getMethods()) {
            Matcher matcher = setPattern.matcher(setterMethod.getName());
            if (!matcher.matches()) continue;
            String firstLetter = matcher.group(1);
            String rest = matcher.group(2);
            String getterName = "get" + firstLetter + rest;
            Method getterMethod = null;
            try {
                getterMethod = type.getMethod(getterName, new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (getterMethod == null || !Modifier.isPublic(getterMethod.getModifiers()) || Modifier.isAbstract(getterMethod.getModifiers()) || Modifier.isStatic(getterMethod.getModifiers())) continue;
            if (theConfig == null) {
                theConfig = injector.getInstance(type);
            }
            try {
                if (theConfig == null) continue;
                Object value = Configs.filterValue(getterMethod.getReturnType(), getterMethod.invoke(theConfig, new Object[0]));
                String id = sectionName + "." + firstLetter.toLowerCase() + rest;
                Configs.defineScalar(content, id, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Object filterValue(Class<?> type, Object value) {
        if (value == null) {
            return "";
        }
        if (File.class.isAssignableFrom(type)) {
            return ((File)value).getAbsolutePath();
        }
        if (URI.class.isAssignableFrom(type)) {
            return ((URI)value).toString();
        }
        if (URL.class.isAssignableFrom(type)) {
            return ((URL)value).toExternalForm();
        }
        return value;
    }

    public static void defineScalar(Map<String, Object> content, String bootiqueVariable, Object value) throws Exception {
        String[] elements = bootiqueVariable.split("\\.");
        Map<String, Object> entry = Configs.getScalarParent(content, elements);
        entry.put(elements[elements.length - 1], value);
    }

    private static Map<String, Object> getScalarParent(Map<String, Object> content, String[] elements) throws Exception {
        Map entry = content;
        for (int i = 0; i < elements.length - 1; ++i) {
            Object val = entry.get(elements[i]);
            if (val instanceof Map) {
                Map mentry;
                entry = mentry = (Map)val;
                continue;
            }
            Map newElement = (Map)content.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            entry.put(elements[i], newElement);
            entry = newElement;
        }
        assert (entry != null);
        return entry;
    }
}

