/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.bootique.synopsishelp.help;

import com.google.common.base.Strings;
import io.bootique.help.ConsoleAppender;
import io.bootique.help.DefaultHelpGenerator;
import io.bootique.help.HelpAppender;
import io.bootique.meta.application.ApplicationMetadata;
import java.lang.reflect.Method;

public class SynopsisHelpGenerator
extends DefaultHelpGenerator {
    private static final String SYNOPSIS = "SYNOPSIS";
    private static final String DETAILED_DESCRIPTION = "DESCRIPTION";
    private static final String OPTION_SYNOPSIS = " [OPTIONS]... ";
    private static final String ARGUMENT_SYNOPSIS = " [ARGUMENT]... ";
    private final ApplicationMetadata metadata;
    private final String argumentSynopsis;
    private final String detailedDescription;

    public SynopsisHelpGenerator(ApplicationMetadata metadata, String argumentSynopsis, String detailedDescription, int lineWidth) {
        super(metadata, lineWidth);
        this.metadata = metadata;
        this.detailedDescription = detailedDescription;
        this.argumentSynopsis = argumentSynopsis == null ? ARGUMENT_SYNOPSIS : argumentSynopsis;
    }

    protected SynopsisHelpAppender createAppender(Appendable out) {
        return new SynopsisHelpAppender(this.createConsoleAppender(out));
    }

    protected ApplicationMetadata getApplicationMetadata() {
        return this.metadata;
    }

    public void append(Appendable out) {
        SynopsisHelpAppender appender = this.createAppender(out);
        ApplicationMetadata meta = this.getApplicationMetadata();
        String name = meta.getName();
        this.printName(appender, name, meta.getDescription());
        this.printSynopsis(appender, name, this.argumentSynopsis);
        this.printDetailedDescription(appender, this.detailedDescription);
        this.printOptions(appender, meta.getCliOptions());
        this.printEnvironment(appender, meta.getVariables());
    }

    protected void printSynopsis(HelpAppender out, String name, String argumentSynopsis) {
        out.printSectionName(SYNOPSIS);
        assert (name != null);
        if (Strings.isNullOrEmpty((String)argumentSynopsis)) {
            out.printText(new String[]{name, OPTION_SYNOPSIS});
        } else {
            out.printText(new String[]{name, OPTION_SYNOPSIS, argumentSynopsis});
        }
    }

    protected void printDetailedDescription(SynopsisHelpAppender out, String detailedDescription) {
        if (!Strings.isNullOrEmpty((String)detailedDescription)) {
            out.printSectionName(DETAILED_DESCRIPTION);
            out.printLongDescription(detailedDescription.split("[\r\n\f]+"));
        }
    }

    protected static class SynopsisHelpAppender
    extends HelpAppender {
        private transient ConsoleAppender offsetAppender;
        private transient ConsoleAppender doubleOffsetAppender;

        public SynopsisHelpAppender(ConsoleAppender appender) {
            super(appender);
        }

        protected ConsoleAppender getOrCreateOffsetAppender() {
            if (this.offsetAppender == null) {
                try {
                    Method method = HelpAppender.class.getDeclaredMethod("getOrCreateOffsetAppender", new Class[0]);
                    method.setAccessible(true);
                    this.offsetAppender = (ConsoleAppender)method.invoke((Object)this, new Object[0]);
                }
                catch (Throwable exception) {
                    throw new Error(exception);
                }
            }
            return this.offsetAppender;
        }

        protected ConsoleAppender getOrCreateDoubleOffsetAppender() {
            if (this.doubleOffsetAppender == null) {
                try {
                    Method method = HelpAppender.class.getDeclaredMethod("getOrCreateDoubleOffsetAppender", new Class[0]);
                    method.setAccessible(true);
                    this.doubleOffsetAppender = (ConsoleAppender)method.invoke((Object)this, new Object[0]);
                }
                catch (Throwable exception) {
                    throw new Error(exception);
                }
            }
            return this.doubleOffsetAppender;
        }

        public void printLongDescription(String ... parts) {
            ConsoleAppender appender = this.getOrCreateOffsetAppender();
            boolean first = true;
            for (String paragraph : parts) {
                if (first) {
                    first = false;
                } else {
                    appender.println(new String[]{""});
                }
                appender.foldPrintln(new String[]{paragraph});
            }
        }
    }
}

