/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.bootique.synopsishelp.modules;

import io.bootique.BQModule;
import io.bootique.di.Binder;
import io.bootique.di.Injector;
import io.bootique.di.Key;
import io.bootique.di.Provides;
import io.bootique.help.HelpGenerator;
import io.bootique.meta.application.ApplicationMetadata;
import io.bootique.terminal.Terminal;
import jakarta.inject.Singleton;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationArgumentSynopsis;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationDetailedDescription;
import org.arakhne.afc.bootique.synopsishelp.help.SynopsisHelpGenerator;

public class SynopsisHelpGeneratorModule
implements BQModule {
    private static final int TTY_MIN_COLUMNS = 40;
    private static final int TTY_DEFAULT_COLUMNS = 80;

    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public HelpGenerator provideHelpGenerator(ApplicationMetadata metadata, Injector injector, Terminal terminal) {
        String detailedDescription;
        String argumentSynopsis;
        int maxColumns = terminal.getColumns();
        if (maxColumns < 40) {
            maxColumns = 80;
        }
        try {
            argumentSynopsis = (String)injector.getInstance(Key.get(String.class, ApplicationArgumentSynopsis.class));
        }
        catch (Exception exception) {
            argumentSynopsis = null;
        }
        try {
            detailedDescription = (String)injector.getInstance(Key.get(String.class, ApplicationDetailedDescription.class));
        }
        catch (Exception exception) {
            detailedDescription = null;
        }
        return new SynopsisHelpGenerator(metadata, argumentSynopsis, detailedDescription, maxColumns);
    }
}

