/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.bootique.variables;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VariableNames {
    public static final String BOOTIQUE_PROPERTY_PREFIX = "bq.";

    private VariableNames() {
    }

    public static String toPropertyName(String bootiqueVariable) {
        if (Strings.isNullOrEmpty((String)bootiqueVariable)) {
            return null;
        }
        return BOOTIQUE_PROPERTY_PREFIX + bootiqueVariable;
    }

    public static String toEnvironmentVariableName(String bootiqueVariable) {
        if (Strings.isNullOrEmpty((String)bootiqueVariable)) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        Pattern pattern = Pattern.compile("((?:[a-z0_9_]+)|(?:[A-Z]+[^A-Z]*))");
        for (String component : bootiqueVariable.split("[^a-zA-Z0_9_]+")) {
            Matcher matcher = pattern.matcher(component);
            while (matcher.find()) {
                String word = matcher.group(1);
                if (name.length() > 0) {
                    name.append("_");
                }
                name.append(word.toUpperCase());
            }
        }
        return name.toString();
    }

    public static String basename(String bootiqueVariable) {
        int idx = bootiqueVariable.lastIndexOf(46);
        if (idx >= 0) {
            return bootiqueVariable.substring(idx + 1);
        }
        return bootiqueVariable;
    }
}

