/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.services;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.arakhne.afc.services.IPreReleasableService;
import org.arakhne.afc.services.IService;
import org.arakhne.afc.services.IServiceManager;
import org.arakhne.afc.services.ServiceState;
import org.arakhne.afc.vmutil.locale.Locale;

public abstract class AbstractServiceManager
implements IServiceManager {
    private Logger logger;
    private final Multimap<ServiceState, IService> servicesByState = LinkedListMultimap.create();
    private final Map<Class<? extends IService>, IService> servicesByType = new HashMap<Class<? extends IService>, IService>();

    public AbstractServiceManager(Iterable<? extends IService> services) {
        for (IService iService : services) {
            this.servicesByState.put((Object)ServiceState.NEW, (Object)iService);
            this.servicesByType.put(iService.getReferenceType(), iService);
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Multimap<ServiceState, IService> getServicesByState() {
        return Multimaps.unmodifiableMultimap(this.servicesByState);
    }

    protected Collection<IService> getServicesByState(ServiceState state) {
        Collection list = this.servicesByState.get((Object)state);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public <T extends IService> T getService(Class<T> type) {
        return (T)((IService)type.cast(this.servicesByType.get(type)));
    }

    protected void startService(IService service) {
        if (service.getState() == ServiceState.NEW) {
            this.servicesByState.remove((Object)ServiceState.NEW, (Object)service);
            service.setState(ServiceState.STARTING);
            this.servicesByState.put((Object)ServiceState.STARTING, (Object)service);
            service.onStart();
            this.servicesByState.remove((Object)ServiceState.STARTING, (Object)service);
            service.setState(ServiceState.RUNNING);
            this.servicesByState.put((Object)ServiceState.RUNNING, (Object)service);
        }
    }

    protected void stopService(IService service) {
        if (service.getState() == ServiceState.RUNNING) {
            this.servicesByState.remove((Object)ServiceState.RUNNING, (Object)service);
            service.setState(ServiceState.STOPPING);
            this.servicesByState.put((Object)ServiceState.STOPPING, (Object)service);
            service.onStop();
            this.servicesByState.remove((Object)ServiceState.STOPPING, (Object)service);
            service.setState(ServiceState.STOPPED);
            this.servicesByState.put((Object)ServiceState.STOPPED, (Object)service);
        }
    }

    @Override
    public void startServices(Logger logger) {
        this.setLogger(logger);
        this.internalStartAllServices();
    }

    @Override
    public void stopServices(Logger logger) {
        this.preStop(logger);
        logger.fine(Locale.getString((String)"AbstractServiceManager_0", (Object[])new Object[0]));
        this.internalStopAllServices();
    }

    protected void preStop(Logger logger) {
        logger.fine(Locale.getString((String)"AbstractServiceManager_1", (Object[])new Object[0]));
        for (IService service : this.getServicesByState(ServiceState.RUNNING)) {
            if (!(service instanceof IPreReleasableService)) continue;
            IPreReleasableService iservice = (IPreReleasableService)service;
            iservice.onPreStop();
        }
    }

    protected abstract void internalStartAllServices();

    protected abstract void internalStopAllServices();
}

