/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.boot.internal.cli;

import io.bootique.BQCoreModule;
import io.bootique.BQCoreModuleExtender;
import io.bootique.BQModule;
import io.bootique.di.Binder;
import io.sarl.apputils.bootiqueapp.utils.SystemProperties;
import io.sarl.lang.core.SARLVersion;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.boot.commands.RunSingleAgentCommand;
import io.sarl.sre.janus.boot.configs.SreConfig;
import jakarta.inject.Provider;
import java.text.MessageFormat;
import org.arakhne.afc.bootique.applicationdata2.annotations.DefaultApplicationName;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationArgumentSynopsis;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationDetailedDescription;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Module for configuring the janus application information.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version janus 3.0.15.1 20250911-224827
 * @mavengroupid io.sarl.cli
 * @mavenartifactid janus
 * @since 3.0.11.0
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class JanusApplicationModule implements BQModule {
  /**
   * Provider of the long description of the application.
   * 
   * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
   * @version janus 3.0.15.1 20250911-224827
   * @mavengroupid io.sarl.cli
   * @mavenartifactid janus
   * @since 3.0.11.0
   */
  @SarlSpecification("0.15")
  @SarlElementType(10)
  @XbaseGenerated
  private static class LongDescriptionProvider implements Provider<String> {
    @Override
    public String get() {
      final String implementationSarlVersion = SARLVersion.SPECIFICATION_RELEASE_VERSION_STRING;
      final String implementationJavaVersion = SARLVersion.MINIMAL_JDK_VERSION_FOR_SARL_COMPILATION_ENVIRONMENT;
      return MessageFormat.format(Messages.JanusApplicationModule_2, implementationSarlVersion, implementationJavaVersion);
    }

    @SyntheticMember
    public LongDescriptionProvider() {
      super();
    }
  }

  @Override
  public void configure(@Extension final Binder binder) {
    binder.<String>bind(String.class, DefaultApplicationName.class).toInstance(
      SystemProperties.getValue((SreConfig.PREFIX + ".programName"), SreConfig.DEFAULT_PROGRAM_NAME));
    BQCoreModuleExtender _extend = BQCoreModule.extend(binder);
    _extend.setApplicationDescription(Messages.JanusApplicationModule_0);
    binder.<String>bind(String.class, ApplicationDetailedDescription.class).toJakartaProvider(JanusApplicationModule.LongDescriptionProvider.class).inSingletonScope();
    binder.<String>bind(String.class, ApplicationArgumentSynopsis.class).toInstance(Messages.JanusApplicationModule_1);
    BQCoreModuleExtender _extend_1 = BQCoreModule.extend(binder);
    _extend_1.setDefaultCommand(RunSingleAgentCommand.class);
  }

  @SyntheticMember
  public JanusApplicationModule() {
    super();
  }
}
