/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.boot.internal.cli;

import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Messages for the SARL batch compiler.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version janus 3.0.15.1 20250911-224827
 * @mavengroupid io.sarl.cli
 * @mavenartifactid janus
 * @ExcludeFromApidoc
 * @since 3.0.11.0
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public final class Messages extends NLS {
  private static final String BUNDLE_NAME = (Messages.class.getPackageName() + ".messages");

  static {
    NLS.initializeMessages(Messages.BUNDLE_NAME, Messages.class);
  }

  public static String JanusApplicationModuleProvider_0;

  public static String JanusApplicationModule_0;

  public static String JanusApplicationModule_1;

  public static String JanusApplicationModule_2;

  public static String VersionCommand_0;

  public static String VersionCommand_1;

  public static String VersionCommandModuleProvider_0;

  private Messages() {
  }
}
