/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.boot.internal.cli;

import io.bootique.log.BootLogger;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.sre.janus.SreVersion;
import java.text.MessageFormat;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Command for showing the SRE version.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version janus 3.0.15.1 20250911-224827
 * @mavengroupid io.sarl.cli
 * @mavenartifactid janus
 * @since 3.0.11.0
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class VersionCommand extends io.sarl.apputils.bootiqueapp.version.VersionCommand {
  /**
   * Constructor.
   * 
   * @param bootLogger the logger.
   */
  public VersionCommand(final BootLogger bootLogger) {
    super(bootLogger, VersionCommand.class, Messages.VersionCommand_0);
  }

  @Override
  protected String getVersionMessage() {
    final String inheritedMessage = super.getVersionMessage();
    return MessageFormat.format(Messages.VersionCommand_1, 
      SreVersion.RELEASE_VERSION, 
      Boolean.valueOf(SreVersion.IS_STABLE), inheritedMessage);
  }
}
