/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.network.boot.internal.cli;

import io.bootique.BQModule;
import io.bootique.BQModuleMetadata;
import io.bootique.BQModuleProvider;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.boot.internal.cli.JanusApplicationModule;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Provider of the module for the janusnode application information.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version janusnode 3.0.15.1 20250911-224827
 * @mavengroupid io.sarl.cli
 * @mavenartifactid janusnode
 * @since 3.0.11.0
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class JanusnodeApplicationModuleProvider implements BQModuleProvider {
  @Override
  public BQModule module() {
    return new JanusnodeApplicationModule();
  }

  @Override
  public Collection<Class<? extends BQModule>> overrides() {
    return Collections.<Class<? extends BQModule>>unmodifiableList(CollectionLiterals.<Class<? extends BQModule>>newArrayList(JanusApplicationModule.class));
  }

  @Override
  public BQModuleMetadata.Builder moduleBuilder() {
    return BQModuleMetadata.builder(this.module()).overrides(this.overrides()).providerName(this.name()).configs(this.configs()).description(
      Messages.JanusnodeApplicationModuleProvider_0);
  }

  @SyntheticMember
  public JanusnodeApplicationModuleProvider() {
    super();
  }
}
