/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.network.boot.internal.cli;

import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.boot.Boot;
import io.sarl.sre.janus.network.boot.configs.SreNetworkConfig;
import org.arakhne.afc.bootique.variables.VariableNames;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Command status Janus with networking feature turned on.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version janusnode 3.0.15.1 20250911-224827
 * @mavengroupid io.sarl.cli
 * @mavenartifactid janusnode
 * @since 0.12
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class NetworkBoot {
  /**
   * Replies the default name of the program.
   * 
   * @return the default name of the program.
   */
  @Inline(value = "\"janusnode\"", constantExpression = true)
  @Pure
  public static String getDefaultSreProgramName() {
    return SreNetworkConfig.DEFAULT_PROGRAM_NAME;
  }

  /**
   * Main program.
   * 
   * @param args the command line arguments.
   */
  @SuppressWarnings("discouraged_reference")
  public static void main(final String... args) {
    final String propName = VariableNames.toPropertyName(SreNetworkConfig.ENABLE_NAME);
    final String propValue = System.getProperty(propName, null);
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(propValue);
    if (_isNullOrEmpty) {
      System.setProperty(propName, Boolean.TRUE.toString());
    }
    Boot.main(args);
  }

  @SyntheticMember
  public NetworkBoot() {
    super();
  }
}
