/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.commands;

import com.google.common.base.Strings;
import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.di.BQInject;
import io.bootique.meta.application.CommandMetadata;
import io.sarl.lang.compiler.batch.SarlBatchCompiler;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.sarlc.commands.Messages;
import io.sarl.lang.sarlc.configs.ProgressBarConfig;
import io.sarl.lang.sarlc.configs.SarlcConfig;
import io.sarl.lang.sarlc.tools.PathDetector;
import jakarta.inject.Provider;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtext.diagnostics.Severity;

public class CompilerCommand
extends CommandWithMetadata {
    public static final String PROGRESS_OPTION_NAME = "progress";
    private final Provider<SarlBatchCompiler> compiler;
    private final Provider<SarlcConfig> configuration;
    private final Provider<PathDetector> pathDetector;
    private final Provider<ProgressBarConfig> progressConfig;

    @BQInject
    public CompilerCommand(Provider<SarlBatchCompiler> compiler, Provider<SarlcConfig> configuration, Provider<PathDetector> pathDetector, Provider<ProgressBarConfig> progressConfig) {
        super(CommandMetadata.builder(CompilerCommand.class).description(Messages.CompilerCommand_0));
        this.compiler = compiler;
        this.configuration = configuration;
        this.pathDetector = pathDetector;
        this.progressConfig = progressConfig;
    }

    public CommandOutcome run(Cli cli) {
        if (cli.standaloneArguments().isEmpty()) {
            return CommandOutcome.failed((int)255, (String)Messages.CompilerCommand_1);
        }
        SarlcConfig config = (SarlcConfig)this.configuration.get();
        PathDetector paths = (PathDetector)this.pathDetector.get();
        paths.setSarlOutputPath(config.getOutputPath());
        paths.setClassOutputPath(config.getClassOutputPath());
        paths.setTempDirectory(config.getTempDirectory());
        try {
            paths.resolve(cli.standaloneArguments());
        }
        catch (IOException exception) {
            return CommandOutcome.failed((int)255, (Throwable)exception);
        }
        SarlBatchCompiler comp = (SarlBatchCompiler)this.compiler.get();
        comp.setOutputPath(paths.getSarlOutputPath());
        comp.setClassOutputPath(paths.getClassOutputPath());
        comp.setTempDirectory(paths.getTempDirectory());
        for (String cliArg : cli.standaloneArguments()) {
            comp.addSourcePath(cliArg);
        }
        OutParameter firstErrorMessage = new OutParameter();
        AtomicInteger nbErrors = new AtomicInteger(0);
        AtomicInteger nbWarnings = new AtomicInteger(0);
        comp.addIssueMessageListener((severity, issue, uri, message) -> {
            if (firstErrorMessage.get() == null) {
                firstErrorMessage.set((Object)message);
            }
            if (issue.isSyntaxError() || severity == Severity.ERROR) {
                nbErrors.incrementAndGet();
            } else if (issue.getSeverity() == Severity.WARNING) {
                nbWarnings.incrementAndGet();
            }
        });
        AtomicInteger nbFiles = new AtomicInteger(0);
        comp.addCompiledResourceReceiver(it -> nbFiles.incrementAndGet());
        String extraGenerators = config.getExtraGenerators();
        if (!Strings.isNullOrEmpty((String)extraGenerators)) {
            comp.setExtraLanguageGenerators(extraGenerators);
        }
        return this.runCompiler(comp, (OutParameter<String>)firstErrorMessage, nbErrors, nbWarnings, nbFiles);
    }

    private CommandOutcome runCompiler(SarlBatchCompiler comp, OutParameter<String> firstErrorMessage, AtomicInteger nbErrors, AtomicInteger nbWarnings, AtomicInteger nbFiles) {
        ProgressBarConfig progressConfig = (ProgressBarConfig)this.progressConfig.get();
        boolean compilationResult = progressConfig.getEnable() ? comp.compile((IProgressMonitor)new ConsoleProgressMonitor(progressConfig.getStyle())) : comp.compile();
        if (!compilationResult) {
            CompilerCommand.showErrorAndWarningCount(comp, nbErrors, nbWarnings, nbFiles);
            return CommandOutcome.failed((int)255, (String)Strings.nullToEmpty((String)((String)firstErrorMessage.get())));
        }
        CompilerCommand.showWarningCount(comp, nbWarnings, nbFiles);
        return CommandOutcome.succeeded();
    }

    private static void showErrorAndWarningCount(SarlBatchCompiler comp, Number errs, Number warns, Number files) {
        long errValue = errs.longValue();
        if (errValue > 0L) {
            long warnValue = warns.longValue();
            String msg = errValue > 1L ? (warnValue > 1L ? Messages.CompilerCommand_2 : (warnValue == 1L ? Messages.CompilerCommand_3 : Messages.CompilerCommand_4)) : (warnValue > 1L ? Messages.CompilerCommand_5 : (warnValue == 1L ? Messages.CompilerCommand_6 : Messages.CompilerCommand_7));
            comp.getLogger().info(MessageFormat.format(msg, errValue, warnValue));
        } else {
            CompilerCommand.showWarningCount(comp, warns, files);
        }
    }

    private static void showWarningCount(SarlBatchCompiler comp, Number warns, Number files) {
        long value = warns.longValue();
        String msg = value > 0L ? (value > 1L ? Messages.CompilerCommand_8 : Messages.CompilerCommand_9) : Messages.CompilerCommand_10;
        comp.getLogger().info(MessageFormat.format(msg, value, files));
    }

    private static class ConsoleProgressMonitor
    implements IProgressMonitor {
        private final ProgressBarBuilder builder;
        private ProgressBar bar;
        private boolean isCanceled;

        ConsoleProgressMonitor(io.sarl.lang.sarlc.configs.ProgressBarStyle style) {
            this.builder = new ProgressBarBuilder().setStyle(style.toBackgroundStyle());
        }

        private void ensureBar() {
            if (this.bar == null) {
                this.bar = this.builder.build();
            }
        }

        public void beginTask(String name, int totalWorkUnits) {
            if (!Strings.isNullOrEmpty((String)name)) {
                this.builder.setTaskName(name);
            }
            this.builder.setStyle(ProgressBarStyle.COLORFUL_UNICODE_BLOCK).setInitialMax((long)totalWorkUnits);
        }

        public void done() {
            this.ensureBar();
            this.bar.stepTo(this.bar.getMax());
            this.bar.close();
        }

        public void internalWorked(double workUnits) {
            this.ensureBar();
            this.bar.setExtraMessage("").stepTo((long)workUnits);
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void setCanceled(boolean cancel) {
            this.isCanceled = cancel;
        }

        public void setTaskName(String name) {
            if (!Strings.isNullOrEmpty((String)name)) {
                this.builder.setTaskName(name);
            }
        }

        public void subTask(String name) {
        }

        public void worked(int workUnits) {
            this.ensureBar();
            this.bar.setExtraMessage("").stepTo((long)workUnits);
        }
    }
}

