/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.commands;

import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.di.BQInject;
import io.bootique.log.BootLogger;
import io.bootique.meta.application.CommandMetadata;
import io.sarl.lang.extralanguage.IExtraLanguageContribution;
import io.sarl.lang.extralanguage.IExtraLanguageContributions;
import io.sarl.lang.sarlc.commands.Messages;
import jakarta.inject.Provider;
import java.util.TreeSet;

public class ExtraLanguageListCommand
extends CommandWithMetadata {
    public static final String EXTRA_LANGUAGE_LIST_OPTION_NAME = "print-generators";
    public static final char EXTRA_LANGUAGE_LIST_OPTION_SHORT_NAME = 'G';
    private final BootLogger bootLogger;
    private final Provider<IExtraLanguageContributions> contributions;

    @BQInject
    public ExtraLanguageListCommand(BootLogger bootLogger, Provider<IExtraLanguageContributions> contributions) {
        super(CommandMetadata.builder(ExtraLanguageListCommand.class).description(Messages.ExtraLanguageListCommand_0).name(EXTRA_LANGUAGE_LIST_OPTION_NAME).shortName('G'));
        this.bootLogger = bootLogger;
        this.contributions = contributions;
    }

    public CommandOutcome run(Cli cli) {
        TreeSet identifiers = new TreeSet();
        for (IExtraLanguageContribution contribution : ((IExtraLanguageContributions)this.contributions.get()).getContributions()) {
            identifiers.addAll(contribution.getIdentifiers());
        }
        StringBuilder text = new StringBuilder();
        for (String id : identifiers) {
            text.append(id).append("\n");
        }
        this.bootLogger.stdout(text.toString());
        return CommandOutcome.succeeded();
    }
}

