/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.configs;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.ConfigurationFactory;
import io.sarl.apputils.bootiqueapp.config.Level;
import io.sarl.lang.sarlc.configs.ProgressBarStyle;

@BQConfig(value="Configuration of the SARLC tool")
public class ProgressBarConfig {
    public static final String PREFIX = "progressBar";
    public static final String ENABLE = "progressBar.enable";
    public static final String LEVEL = "progressBar.level";
    public static final Level DEFAULT_LEVEL = Level.ERROR;
    public static final String STYLE = "progressBar.style";
    public static final ProgressBarStyle DEFAULT_STYLE = ProgressBarStyle.COLORED_UNICODE;
    private boolean enable;
    private Level level = DEFAULT_LEVEL;
    private ProgressBarStyle style = DEFAULT_STYLE;

    public static ProgressBarConfig getConfiguration(ConfigurationFactory configFactory) {
        assert (configFactory != null);
        return (ProgressBarConfig)configFactory.config(ProgressBarConfig.class, PREFIX);
    }

    public boolean getEnable() {
        return this.enable;
    }

    @BQConfigProperty(value="Enable or disable the progress bar.")
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Level getLevel() {
        return this.level;
    }

    @BQConfigProperty(value="Specify the logger level that should be used when the progress bar is active. Default is ERROR.")
    public void setLevel(Level level) {
        this.level = level == null ? DEFAULT_LEVEL : level;
    }

    public ProgressBarStyle getStyle() {
        return this.style;
    }

    @BQConfigProperty(value="Specify the style of the progress bar. Default is COLORED_UNICODE.")
    public void setStyle(ProgressBarStyle style) {
        this.style = style == null ? DEFAULT_STYLE : style;
    }
}

