/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.configs;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.ConfigurationFactory;
import io.sarl.lang.sarlc.configs.subconfigs.CompilerConfig;
import io.sarl.lang.sarlc.configs.subconfigs.ValidatorConfig;
import java.io.File;

@BQConfig(value="Configuration of the SARLC tool")
public class SarlcConfig {
    public static final String PREFIX = "sarlc";
    public static final String OUTPUT_PATH_NAME = "sarlc.outputPath";
    public static final String TEMP_DIRECTORY_NAME = "sarlc.tempDirectory";
    public static final String CLASS_OUTPUT_PATH_NAME = "sarlc.classOutputPath";
    public static final String CLASSPATH_NAME = "sarlc.classpath";
    public static final String MODULEPATH_NAME = "sarlc.modulepath";
    @Deprecated(forRemoval=true, since="0.12")
    public static final String JAVA_BOOT_CLASSPATH_NAME = "sarlc.javaBootClasspath";
    public static final String BOOT_CLASSPATH_NAME = "sarlc.bootClasspath";
    public static final String EXTRA_GENERATOR_NAME = "sarlc.extraGenerators";
    private String classPath;
    private String modulePath;
    private String bootClasspath;
    @Deprecated(forRemoval=true, since="0.12")
    private String javaBootClasspath;
    private File outputPath;
    private File classOutputPath;
    private File tempDirectory;
    private CompilerConfig compilerConfig;
    private ValidatorConfig validatorConfig;
    private String extraGenerators;

    public static SarlcConfig getConfiguration(ConfigurationFactory configFactory) {
        assert (configFactory != null);
        return (SarlcConfig)configFactory.config(SarlcConfig.class, PREFIX);
    }

    public String getClasspath() {
        return this.classPath;
    }

    @BQConfigProperty(value="Class path for the SARL compiler.")
    public void setClasspath(String path) {
        this.classPath = path;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    @BQConfigProperty(value="Module path for the SARL compiler.")
    public void setModulePath(String path) {
        this.modulePath = path;
    }

    public String getBootClasspath() {
        return this.bootClasspath;
    }

    @BQConfigProperty(value="SARL boot class path for the SARL compiler.")
    public void setBootClasspath(String path) {
        this.bootClasspath = path;
    }

    @Deprecated(forRemoval=true, since="0.12")
    public String getJavaBootClasspath() {
        return this.javaBootClasspath;
    }

    @Deprecated(forRemoval=true, since="0.12")
    @BQConfigProperty(value="Java boot class path for the SARL compiler.")
    public void setJavaBootClasspath(String path) {
        this.javaBootClasspath = path;
    }

    public File getClassOutputPath() {
        return this.classOutputPath;
    }

    @BQConfigProperty(value="Output path for the Java compiler in which the byte-code is written.")
    public void setClassOutputPath(File path) {
        this.classOutputPath = path;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    @BQConfigProperty(value="Output path for the SARL compiler in which the Java code is written.")
    public void setOutputPath(File path) {
        this.outputPath = path;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    @BQConfigProperty(value="Working/temporary path for the SARL compiler.")
    public void setTempDirectory(File path) {
        this.tempDirectory = path;
    }

    public CompilerConfig getCompiler() {
        if (this.compilerConfig == null) {
            this.compilerConfig = new CompilerConfig();
        }
        return this.compilerConfig;
    }

    @BQConfigProperty(value="Configuration of the SARL compiler.")
    public void setCompiler(CompilerConfig config) {
        this.compilerConfig = config;
    }

    public ValidatorConfig getValidator() {
        if (this.validatorConfig == null) {
            this.validatorConfig = new ValidatorConfig();
        }
        return this.validatorConfig;
    }

    @BQConfigProperty(value="Configuration of the SARL validator.")
    public void setValidator(ValidatorConfig config) {
        this.validatorConfig = config;
    }

    public String getExtraGenerators() {
        return this.extraGenerators;
    }

    @BQConfigProperty(value="List of the enable extra-language generators.")
    public void setExtraGenerators(String identifiers) {
        this.extraGenerators = identifiers;
    }
}

