/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.configs.subconfigs;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import io.sarl.lang.sarlc.configs.subconfigs.JavaCompiler;
import java.nio.charset.Charset;

@BQConfig(value="Configuration of the SARL compiler")
public class CompilerConfig {
    public static final String PREFIX = "sarlc.compiler";
    public static final String FILE_ENCODING_NAME = "sarlc.compiler.fileEncoding";
    public static final String JAVA_VERSION_NAME = "sarlc.compiler.javaVersion";
    public static final String JAVA_COMPILER_NAME = "sarlc.compiler.javaCompiler";
    public static final String OPTIMIZATION_LEVEL_NAME = "sarlc.compiler.optimizationLevel";
    public static final String OUTPUT_TRACES_NAME = "sarlc.compiler.outputTraceFiles";
    public static final String OUTPUT_STORAGES_NAME = "sarlc.compiler.outputStorageFiles";
    public static final String GENERATE_INLINES_NAME = "sarlc.compiler.generateInlines";
    public static final String GENERATE_PURES_NAME = "sarlc.compiler.generatePures";
    public static final String GENERATE_EQUALITY_TESTS_NAME = "sarlc.compiler.generateEqualityTests";
    public static final String GENERATE_TOSTRING_NAME = "sarlc.compiler.generateToString";
    public static final String GENERATE_CLONE_NAME = "sarlc.compiler.generateClone";
    public static final String GENERATE_SERIAL_IDS_NAME = "sarlc.compiler.generateSerialIds";
    public static final String COMPRESS_INLINE_EXPRESSIONS_NAME = "sarlc.compiler.compressInlineExpressions";
    private String fileEncoding;
    private String javaVersion = "21";
    private JavaCompiler javaCompiler;
    private OptimizationLevel optimizationLevel;
    private boolean traceFiles = true;
    private boolean storageFiles = true;
    private boolean generateInlines = false;
    private boolean generatePures = true;
    private boolean generateEqualityTests = true;
    private boolean generateToString = true;
    private boolean generateClone = true;
    private boolean generateSerialIds = true;
    private boolean compressInlineExpressions = true;

    public boolean getCompressInlineExpressions() {
        return this.compressInlineExpressions;
    }

    @BQConfigProperty(value="Enable or disable the generation of the serial numbers")
    public void setCompressInlineExpressions(boolean enable) {
        this.compressInlineExpressions = enable;
    }

    public boolean getGenerateSerialIds() {
        return this.generateSerialIds;
    }

    @BQConfigProperty(value="Enable or disable the generation of the serial numbers")
    public void setGenerateSerialIds(boolean enable) {
        this.generateSerialIds = enable;
    }

    public boolean getGenerateClone() {
        return this.generateClone;
    }

    @BQConfigProperty(value="Enable or disable the generation of the clone functions")
    public void setGenerateClone(boolean enable) {
        this.generateClone = enable;
    }

    public boolean getGenerateToString() {
        return this.generateToString;
    }

    @BQConfigProperty(value="Enable or disable the generation of the toString functions")
    public void setGenerateToString(boolean enable) {
        this.generateToString = enable;
    }

    public boolean getGenerateEqualityTests() {
        return this.generateEqualityTests;
    }

    @BQConfigProperty(value="Enable or disable the generation of the equality tests")
    public void setGenerateEqualityTests(boolean enable) {
        this.generateEqualityTests = enable;
    }

    public boolean getGeneratePures() {
        return this.generatePures;
    }

    @BQConfigProperty(value="Enable or disable the generation of the pure annotations")
    public void setGeneratePures(boolean enable) {
        this.generatePures = enable;
    }

    public boolean getGenerateInlines() {
        return this.generateInlines;
    }

    @BQConfigProperty(value="Enable or disable the generation of the inline annotations")
    public void setGenerateInlines(boolean enable) {
        this.generateInlines = enable;
    }

    public boolean getOutputTraceFiles() {
        return this.traceFiles;
    }

    @BQConfigProperty(value="Enable or disable the creation of the trace files")
    public void setOutputTraceFiles(boolean enable) {
        this.traceFiles = enable;
    }

    public boolean getOutputStorageFiles() {
        return this.storageFiles;
    }

    @BQConfigProperty(value="Enable or disable the creation of the storage files")
    public void setOutputStorageFiles(boolean enable) {
        this.storageFiles = enable;
    }

    public JavaCompiler getJavaCompiler() {
        if (this.javaCompiler == null) {
            this.javaCompiler = JavaCompiler.getDefault();
        }
        return this.javaCompiler;
    }

    @BQConfigProperty(value="Specify the Java compiler to run")
    public void setJavaCompiler(JavaCompiler compiler) {
        this.javaCompiler = compiler;
    }

    public String getOptimizationLevel() {
        return this.getOptimizationLevelObject().toString().toLowerCase();
    }

    public OptimizationLevel getOptimizationLevelObject() {
        if (this.optimizationLevel == null) {
            this.optimizationLevel = OptimizationLevel.getDefault();
        }
        return this.optimizationLevel;
    }

    @BQConfigProperty(value="Specify the level of optimization for the compilers. Possible values are g0 (no optimization), g1 (for basic optimizations), etc.")
    public void setOptimizationLevel(String level) {
        this.optimizationLevel = OptimizationLevel.valueOfCaseInsensitive((String)level);
    }

    public String getFileEncoding() {
        if (this.fileEncoding == null) {
            this.fileEncoding = Charset.defaultCharset().displayName();
        }
        return this.fileEncoding;
    }

    @BQConfigProperty(value="Specify the character encoding of the files. If it is not specified, the value of the system property \"file.encoding\" is used. If this system property was not set, the default encoding is used (usually UTF-8).")
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    @BQConfigProperty(value="Version of Java to be used (11 or higher)")
    public void setJavaVersion(String version) {
        this.javaVersion = version;
    }
}

