/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.configs.subconfigs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import io.sarl.lang.compiler.batch.EcjBatchCompiler;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.JavacBatchCompiler;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import org.eclipse.xtext.xbase.lib.Pure;

public enum JavaCompiler {
    NONE{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return SarlBatchCompilerUtils.getDefaultJavaBatchCompilerImplementationType();
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance() {
            return SarlBatchCompilerUtils.newDefaultJavaBatchCompiler();
        }
    }
    ,
    ECJ{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return EcjBatchCompiler.class;
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance() {
            return new EcjBatchCompiler();
        }
    }
    ,
    JAVAC{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return JavacBatchCompiler.class;
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance() {
            return new JavacBatchCompiler();
        }
    };


    @JsonCreator
    public static JavaCompiler valueOfCaseInsensitive(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new NullPointerException("Name is null");
        }
        return JavaCompiler.valueOf(name.toUpperCase());
    }

    @JsonValue
    public String toJsonString() {
        return this.name().toLowerCase();
    }

    @Pure
    public abstract IJavaBatchCompiler newCompilerInstance();

    @Pure
    public abstract Class<? extends IJavaBatchCompiler> getImplementationType();

    @Pure
    public static JavaCompiler fromImplementationType(Class<? extends IJavaBatchCompiler> type) {
        if (type != null) {
            for (JavaCompiler compiler : JavaCompiler.values()) {
                Class<? extends IJavaBatchCompiler> implementation;
                if (compiler == NONE || (implementation = compiler.getImplementationType()) == null || !implementation.isAssignableFrom(type)) continue;
                return compiler;
            }
        }
        return null;
    }

    @Pure
    public static JavaCompiler getDefault() {
        Class compilerType = SarlBatchCompilerUtils.getDefaultJavaBatchCompilerImplementationType();
        JavaCompiler jc = JavaCompiler.fromImplementationType(compilerType);
        if (jc != null) {
            return jc;
        }
        return ECJ;
    }
}

