/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.modules.commands;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Injector;
import io.bootique.di.Provides;
import io.bootique.meta.application.OptionMetadata;
import io.sarl.lang.compiler.batch.SarlBatchCompiler;
import io.sarl.lang.sarlc.commands.CompilerCommand;
import io.sarl.lang.sarlc.configs.ProgressBarConfig;
import io.sarl.lang.sarlc.configs.SarlcConfig;
import io.sarl.lang.sarlc.modules.commands.Messages;
import io.sarl.lang.sarlc.tools.PathDetector;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class CompilerCommandModule
implements BQModule {
    public void configure(Binder binder) {
        String trueFalseValues = MessageFormat.format(Messages.CompilerCommandModule_1, Boolean.TRUE.toString(), Boolean.FALSE.toString());
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)"progress", (String)MessageFormat.format(Messages.CompilerCommandModule_0, Boolean.TRUE)).valueOptionalWithDefault(trueFalseValues, Boolean.TRUE.toString()).build()).mapConfigPath("progress", "progressBar.enable");
        BQCoreModule.extend((Binder)binder).addCommand(CompilerCommand.class);
    }

    @Provides
    @Singleton
    public CompilerCommand provideSarlcCompilerCommand(Provider<SarlBatchCompiler> sarlCompiler, Provider<SarlcConfig> configuration, Provider<ProgressBarConfig> commandConfig, Provider<PathDetector> pathDetector) {
        return new CompilerCommand(sarlCompiler, configuration, pathDetector, commandConfig);
    }

    @Provides
    @Singleton
    public ProgressBarConfig provideProgressBarConfig(ConfigurationFactory configFactory, Injector injector) {
        ProgressBarConfig config = ProgressBarConfig.getConfiguration(configFactory);
        injector.injectMembers((Object)config);
        return config;
    }

    @Singleton
    @Provides
    public Logger provideRootLogger(ConfigurationFactory configFactory, Provider<ProgressBarConfig> config) {
        Logger logger;
        block9: {
            Class<?> type = this.getClass();
            InputStream stream = type.getResourceAsStream("logging.properties");
            try {
                ProgressBarConfig cfg;
                LogManager.getLogManager().readConfiguration(stream);
                Logger root = Logger.getAnonymousLogger();
                if (root != null && (cfg = (ProgressBarConfig)config.get()).getEnable()) {
                    root.setLevel(cfg.getLevel().toJul());
                }
                logger = root;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
            stream.close();
        }
        return logger;
    }
}

