/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.modules.configs;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.di.Binder;
import io.bootique.meta.application.OptionMetadata;
import io.sarl.lang.sarlc.configs.subconfigs.JavaCompiler;
import io.sarl.lang.sarlc.modules.configs.Messages;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.arakhne.afc.bootique.variables.VariableDecls;

public class CompilerConfigModule
implements BQModule {
    private static final String ENCODING_OPTION = "encoding";
    private static final String JAVASOURCE_OPTION = "java-source";
    private static final String JAVACOMPILER_OPTION = "java-compiler";
    private static final String WRITETRACES_OPTION = "write-traces";
    private static final String WRITESTORAGES_OPTION = "write-storages";
    private static final String GENERATEINLINES_OPTION = "generate-inlines";
    private static final String GENERATEPURES_OPTION = "generate-pures";
    private static final String GENERATEEQUALITYTESTS_OPTION = "generate-equality-tests";
    private static final String GENERATETOSTRING_OPTION = "generate-tostring";
    private static final String GENERATECLONES_OPTION = "generate-clones";
    private static final String GENERATESERIALS_OPTION = "generate-serials";

    public void configure(Binder binder) {
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.fileEncoding");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)ENCODING_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_0, ENCODING_OPTION)).valueOptionalWithDefault(Messages.CompilerConfigModule_1, Charset.defaultCharset().displayName()).build()).mapConfigPath(ENCODING_OPTION, "sarlc.compiler.fileEncoding");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.javaVersion");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)JAVASOURCE_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_2, "21", "27")).valueOptionalWithDefault(Messages.CompilerConfigModule_3, "21").build()).mapConfigPath(JAVASOURCE_OPTION, "sarlc.compiler.javaVersion");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.javaCompiler");
        String jcompilerValues = null;
        for (JavaCompiler jc : JavaCompiler.values()) {
            jcompilerValues = jcompilerValues == null ? jc.toJsonString() : MessageFormat.format(Messages.CompilerConfigModule_5, jcompilerValues, jc.toJsonString());
        }
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)JAVACOMPILER_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_4, JavaCompiler.getDefault().toJsonString())).valueOptionalWithDefault(jcompilerValues, JavaCompiler.getDefault().toJsonString()).build()).mapConfigPath(JAVACOMPILER_OPTION, "sarlc.compiler.javaCompiler");
        String trueFalseValues = MessageFormat.format(Messages.CompilerConfigModule_5, Boolean.TRUE.toString(), Boolean.FALSE.toString());
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.outputTraceFiles");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)WRITETRACES_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_6, Boolean.TRUE)).valueOptionalWithDefault(trueFalseValues, Boolean.TRUE.toString()).build()).mapConfigPath(WRITETRACES_OPTION, "sarlc.compiler.outputTraceFiles");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.outputStorageFiles");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)WRITESTORAGES_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_7, Boolean.TRUE)).valueOptionalWithDefault(trueFalseValues, Boolean.TRUE.toString()).build()).mapConfigPath(WRITESTORAGES_OPTION, "sarlc.compiler.outputStorageFiles");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.generateInlines");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)GENERATEINLINES_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_8, false)).valueOptionalWithDefault(trueFalseValues, Boolean.toString(false)).build()).mapConfigPath(GENERATEINLINES_OPTION, "sarlc.compiler.generateInlines");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.compressInlineExpressions");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.generatePures");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)GENERATEPURES_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_9, true)).valueOptionalWithDefault(trueFalseValues, Boolean.toString(true)).build()).mapConfigPath(GENERATEPURES_OPTION, "sarlc.compiler.generatePures");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.generateEqualityTests");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)GENERATEEQUALITYTESTS_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_10, true)).valueOptionalWithDefault(trueFalseValues, Boolean.toString(true)).build()).mapConfigPath(GENERATEEQUALITYTESTS_OPTION, "sarlc.compiler.generateEqualityTests");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.generateToString");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)GENERATETOSTRING_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_11, true)).valueOptionalWithDefault(trueFalseValues, Boolean.toString(true)).build()).mapConfigPath(GENERATETOSTRING_OPTION, "sarlc.compiler.generateToString");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.generateClone");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)GENERATECLONES_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_12, true)).valueOptionalWithDefault(trueFalseValues, Boolean.toString(true)).build()).mapConfigPath(GENERATECLONES_OPTION, "sarlc.compiler.generateClone");
        VariableDecls.extend((Binder)binder).declareVar("sarlc.compiler.generateSerialIds");
        BQCoreModule.extend((Binder)binder).addOption(OptionMetadata.builder((String)GENERATESERIALS_OPTION, (String)MessageFormat.format(Messages.CompilerConfigModule_13, true)).valueOptionalWithDefault(trueFalseValues, Boolean.toString(true)).build()).mapConfigPath(GENERATESERIALS_OPTION, "sarlc.compiler.generateSerialIds");
    }
}

