/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.modules.general;

import com.google.inject.Injector;
import io.bootique.BQModule;
import io.bootique.di.Binder;
import io.bootique.di.Provides;
import io.sarl.apputils.bootiqueapp.utils.SystemPath;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.IssueMessageFormatter;
import io.sarl.lang.compiler.batch.SarlBatchCompiler;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import io.sarl.lang.sarlc.configs.SarlcConfig;
import io.sarl.lang.sarlc.configs.subconfigs.CompilerConfig;
import io.sarl.lang.sarlc.configs.subconfigs.JavaCompiler;
import io.sarl.lang.sarlc.configs.subconfigs.ValidatorConfig;
import io.sarl.lang.sarlc.tools.ClassPathUtils;
import io.sarl.lang.sarlc.tools.SARLClasspathProvider;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;

public class SarlBatchCompilerModule
implements BQModule {
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public IssueMessageFormatter provideIssueMessageFormatter() {
        return (severity, issue, uriToProblem) -> null;
    }

    @Provides
    @Singleton
    public IJavaBatchCompiler providesJavaBatchCompiler(Provider<SarlcConfig> config, @Named(value="io.sarl.lang.compiler") Injector guiceInjector) {
        SarlcConfig cfg = (SarlcConfig)config.get();
        IJavaBatchCompiler compiler = cfg.getCompiler().getJavaCompiler().newCompilerInstance();
        guiceInjector.injectMembers((Object)compiler);
        return compiler;
    }

    @Provides
    @Singleton
    public SarlBatchCompiler provideSarlBatchCompiler(Provider<SarlcConfig> config, Provider<SARLClasspathProvider> defaultClasspath, @Named(value="io.sarl.lang.compiler") Injector guiceInjector, Provider<Logger> logger, Provider<IssueMessageFormatter> formatterProvider, Provider<IJavaBatchCompiler> javaCompilerProvider) {
        SarlcConfig cfg = (SarlcConfig)config.get();
        CompilerConfig compilerConfig = cfg.getCompiler();
        ValidatorConfig validatorConfig = cfg.getValidator();
        SarlBatchCompiler compiler = new SarlBatchCompiler();
        guiceInjector.injectMembers((Object)compiler);
        if (!Strings.isEmpty((String)compilerConfig.getFileEncoding())) {
            compiler.setFileEncoding(compilerConfig.getFileEncoding());
        }
        JavaVersion jversion = SarlBatchCompilerUtils.parseJavaVersion((String)compilerConfig.getJavaVersion());
        compiler.setJavaSourceVersion(jversion.getQualifier());
        SARLClasspathProvider classpathProvider = (SARLClasspathProvider)defaultClasspath.get();
        SystemPath fullClassPath = ClassPathUtils.buildClassPath(classpathProvider, cfg, jversion, (Logger)logger.get());
        compiler.setClassPath((Collection)fullClassPath.toFileList());
        SystemPath fullModulePath = ClassPathUtils.buildModulePath(classpathProvider, cfg, jversion, (Logger)logger.get());
        compiler.setModulePath((Collection)fullModulePath.toFileList());
        compiler.setOptimizationLevel(cfg.getCompiler().getOptimizationLevelObject());
        compiler.setWriteTraceFiles(compilerConfig.getOutputTraceFiles());
        compiler.setWriteStorageFiles(compilerConfig.getOutputTraceFiles());
        compiler.setGenerateInlineAnnotation(compilerConfig.getGenerateInlines());
        compiler.setUseExpressionInterpreterForInlineAnnotation(compilerConfig.getCompressInlineExpressions());
        compiler.setGeneratePureAnnotation(compilerConfig.getGeneratePures());
        compiler.setGenerateEqualityTestFunctions(compilerConfig.getGenerateEqualityTests());
        compiler.setGenerateToStringFunctions(compilerConfig.getGenerateToString());
        compiler.setGenerateCloneFunctions(compilerConfig.getGenerateClone());
        compiler.setGenerateSerialNumberFields(compilerConfig.getGenerateSerialIds());
        if (validatorConfig.getAllErrors()) {
            compiler.setAllWarningSeverities(Severity.ERROR);
        } else if (validatorConfig.getIgnoreWarnings()) {
            compiler.setAllWarningSeverities(Severity.IGNORE);
        }
        for (Map.Entry<String, Severity> entry : validatorConfig.getWarningLevels().entrySet()) {
            compiler.setWarningSeverity(entry.getKey(), entry.getValue());
        }
        IssueMessageFormatter issueMessageFormatter = (IssueMessageFormatter)formatterProvider.get();
        compiler.setIssueMessageFormatter(issueMessageFormatter);
        JavaCompiler jcompiler = compilerConfig.getJavaCompiler();
        compiler.setJavaPostCompilationEnable(jcompiler != JavaCompiler.NONE);
        compiler.setJavaCompiler((IJavaBatchCompiler)javaCompilerProvider.get());
        return compiler;
    }
}

