/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.tools;

import io.sarl.apputils.bootiqueapp.utils.SystemPath;
import io.sarl.lang.sarlc.configs.SarlcConfig;
import io.sarl.lang.sarlc.tools.Messages;
import io.sarl.lang.sarlc.tools.SARLClasspathProvider;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xtext.util.JavaVersion;

public final class ClassPathUtils {
    private ClassPathUtils() {
    }

    public static SystemPath buildClassPath(SARLClasspathProvider classpathProvider, SarlcConfig cfg, JavaVersion jversion, Logger logger) {
        SystemPath fullClassPath = new SystemPath();
        logger.fine(MessageFormat.format(Messages.ClassPathUtils_0, fullClassPath.toString()));
        SystemPath userClassPath = new SystemPath();
        userClassPath.addEntries(cfg.getClasspath());
        if (userClassPath.isEmpty()) {
            try {
                classpathProvider.getClassPath(userClassPath, logger);
            }
            catch (Throwable exception) {
                logger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        logger.fine(MessageFormat.format(Messages.ClassPathUtils_1, userClassPath.toString()));
        fullClassPath.addEntries(userClassPath);
        return fullClassPath;
    }

    public static SystemPath buildModulePath(SARLClasspathProvider classpathProvider, SarlcConfig cfg, JavaVersion jversion, Logger logger) {
        SystemPath fullModulePath = new SystemPath();
        SystemPath userModulePath = new SystemPath();
        userModulePath.addEntries(cfg.getModulePath());
        if (userModulePath.isEmpty()) {
            try {
                classpathProvider.getModulePath(userModulePath, logger);
            }
            catch (Throwable exception) {
                logger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        logger.fine(MessageFormat.format(Messages.ClassPathUtils_2, userModulePath.toString()));
        fullModulePath.addEntries(userModulePath);
        return fullModulePath;
    }
}

