/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarlc.tools;

import com.google.common.collect.Iterables;
import io.sarl.lang.sarlc.tools.PathDetector;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.xtext.util.Strings;

public class DefaultPathDetector
implements PathDetector {
    private File sarlOutputPath;
    private File classOutputPath;
    private File tempPath;

    @Inject
    public DefaultPathDetector() {
    }

    @Override
    public void setSarlOutputPath(File path) {
        this.sarlOutputPath = path;
    }

    @Override
    public void setClassOutputPath(File path) {
        this.classOutputPath = path;
    }

    @Override
    public void setTempDirectory(File path) {
        this.tempPath = path;
    }

    @Override
    public File getSarlOutputPath() {
        return this.sarlOutputPath;
    }

    @Override
    public File getClassOutputPath() {
        return this.classOutputPath;
    }

    @Override
    public File getTempDirectory() {
        return this.tempPath;
    }

    @Override
    public boolean isResolved() {
        return this.sarlOutputPath != null && this.tempPath != null && this.classOutputPath != null;
    }

    protected Iterable<File> buildResolvablePaths(Iterable<File> userFiles) {
        return Iterables.concat(userFiles, Collections.singleton(this.sarlOutputPath), Collections.singleton(this.tempPath), Collections.singleton(this.classOutputPath));
    }

    protected void normalizePaths(File rootFile) {
        if (this.sarlOutputPath == null) {
            this.sarlOutputPath = DefaultPathDetector.toFile(rootFile, "src/main/generated-sources/sarl");
        }
        if (this.tempPath == null) {
            this.tempPath = DefaultPathDetector.toFile(rootFile, "target/sarl-build");
        }
        if (this.classOutputPath == null) {
            this.classOutputPath = DefaultPathDetector.toFile(rootFile, "target/classes");
        }
    }

    protected void makeAbsolutePaths() throws IOException {
        if (this.sarlOutputPath == null) {
            this.sarlOutputPath = DefaultPathDetector.toFile(DefaultPathDetector.cwd(), "src/main/generated-sources/sarl").getCanonicalFile();
        }
        if (this.sarlOutputPath != null && !this.sarlOutputPath.isAbsolute()) {
            this.sarlOutputPath = FileSystem.join((File)DefaultPathDetector.cwd(), (File[])new File[]{this.sarlOutputPath}).getCanonicalFile();
        }
        if (this.tempPath == null) {
            this.tempPath = DefaultPathDetector.toFile(DefaultPathDetector.cwd(), "target/sarl-build").getCanonicalFile();
        }
        if (this.tempPath != null && !this.tempPath.isAbsolute()) {
            this.tempPath = FileSystem.join((File)DefaultPathDetector.cwd(), (File[])new File[]{this.tempPath}).getCanonicalFile();
        }
        if (this.classOutputPath == null) {
            this.classOutputPath = DefaultPathDetector.toFile(DefaultPathDetector.cwd(), "target/classes").getCanonicalFile();
        }
        if (this.classOutputPath != null && !this.classOutputPath.isAbsolute()) {
            this.classOutputPath = FileSystem.join((File)DefaultPathDetector.cwd(), (File[])new File[]{this.classOutputPath}).getCanonicalFile();
        }
    }

    @Override
    public void resolve(List<String> args) throws IOException {
        Iterable cliFiles;
        File root;
        if (!this.isResolved() && (root = DefaultPathDetector.determineCommonRoot(this.buildResolvablePaths(cliFiles = Iterables.transform(args, it -> DefaultPathDetector.toFile(it))))) != null) {
            root = DefaultPathDetector.normalize(root);
            this.normalizePaths(root);
        }
        this.makeAbsolutePaths();
    }

    protected static File normalize(File filename) {
        Path path1 = DefaultPathDetector.toFile("src/main/sarl").toPath();
        Path path2 = DefaultPathDetector.toFile("src/main/java").toPath();
        Path path3 = DefaultPathDetector.toFile("src/test/sarl").toPath();
        Path path4 = DefaultPathDetector.toFile("src/it/sarl").toPath();
        Path path = filename.toPath();
        Path toRemove = null;
        if (path.endsWith(path1)) {
            toRemove = path1;
        } else if (path.endsWith(path2)) {
            toRemove = path2;
        } else if (path.endsWith(path3)) {
            toRemove = path3;
        } else if (path.endsWith(path4)) {
            toRemove = path4;
        }
        if (toRemove != null) {
            int nb = toRemove.getNameCount();
            File res = filename;
            for (int i = 0; i < nb; ++i) {
                res = res.getParentFile();
            }
            return res;
        }
        return filename;
    }

    protected static File toFile(String filename) {
        File result = null;
        for (String element : filename.split("\\/")) {
            result = result == null ? new File(element) : new File(result, element);
        }
        return result;
    }

    protected static File toFile(File root, String filename) {
        File result = root;
        for (String element : filename.split("\\/")) {
            result = new File(result, element);
        }
        return result;
    }

    protected static File cwd() {
        return new File("").getAbsoluteFile();
    }

    protected static File determineCommonRoot(Iterable<File> files) {
        LinkedList<String> longuestPrefix = null;
        for (File file : files) {
            int i;
            if (file == null) continue;
            LinkedList<String> components = DefaultPathDetector.splitFile(file);
            if (longuestPrefix == null) {
                longuestPrefix = components;
                continue;
            }
            for (i = 0; i < longuestPrefix.size() && i < components.size() && Strings.equal((String)longuestPrefix.get(i), (String)components.get(i)); ++i) {
            }
            while (i < longuestPrefix.size()) {
                longuestPrefix.removeLast();
            }
            if (!longuestPrefix.isEmpty()) continue;
            return null;
        }
        if (longuestPrefix == null) {
            return null;
        }
        File prefix = null;
        for (String component : longuestPrefix) {
            if (prefix == null) {
                prefix = new File(component);
                continue;
            }
            prefix = new File(prefix, component);
        }
        return prefix;
    }

    private static LinkedList<String> splitFile(File file) {
        LinkedList<String> elements = new LinkedList<String>();
        File current = file;
        do {
            elements.addFirst(current.getName());
        } while ((current = current.getParentFile()) != null);
        return elements;
    }
}

