/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.commands;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.meta.application.CommandMetadata;
import io.sarl.apputils.bootiqueapp.utils.SystemPath;
import io.sarl.docs.doclet2.Doclet;
import io.sarl.docs.sarldoc.commands.Messages;
import io.sarl.docs.sarldoc.configs.SarldocConfig;
import io.sarl.docs.sarldoc.configs.Tag;
import io.sarl.docs.sarldoc.tools.DocumentationPathDetector;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import io.sarl.lang.sarlc.configs.SarlcConfig;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.util.JavaVersion;

public abstract class AbstractSarldocCommand
extends CommandWithMetadata {
    protected static final String EMPTY_STRING = "";
    private static final String HTTP_PROTOCOL_NAME = "http";
    private static final String HTTP_HOST_PROPERTY_NAME = "http.proxyHost";
    private static final String HTTP_HOST_VARIABLE_NAME = "http_proxy";
    private static final String HTTP_NONPROXYHOST_PROPERTY_NAME = "http.nonProxyHosts";
    private static final String HTTP_PORT_PROPERTY_NAME = "http.proxyPort";
    private static final String HTTPS_PROTOCOL_NAME = "https";
    private static final String HTTPS_HOST_PROPERTY_NAME = "https.proxyHost";
    private static final String HTTPS_HOST_VARIABLE_NAME = "https_proxy";
    private static final String HTTPS_NONPROXYHOST_PROPERTY_NAME = "https.nonProxyHosts";
    private static final String HTTPS_PORT_PROPERTY_NAME = "https.proxyPort";
    private static final String SIMPLE_URL_PATTERN = "%s://%s";
    private static final String PORT_URL_PATTERN = "%s://%s:%s";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String JAVA_FILE_EXTENSION = "java";
    private static final String LOCALE_FLAG = "-locale";
    private static final String ENCODING_FLAG = "-encoding";
    private static final String SOURCE_FLAG = "-source";
    private static final String DOCTITLE_FLAG = "-doctitle";
    private static final String PUBLIC_FLAG = "-public";
    private static final String PROTECTED_FLAG = "-protected";
    private static final String PACKAGE_FLAG = "-package";
    private static final String PRIVATE_FLAG = "-private";
    private static final String TAG_FLAG = "-tag";
    private final Provider<SarldocConfig> config;
    private final Provider<SarlcConfig> sarlcConfig;
    private final Provider<DocumentationPathDetector> pathDetector;
    private final Provider<Logger> logger;

    @Inject
    public AbstractSarldocCommand(Provider<Logger> logger, Provider<SarldocConfig> config, Provider<SarlcConfig> sarlcConfig, Provider<DocumentationPathDetector> pathDetector, String name) {
        super(AbstractSarldocCommand.addName(name, CommandMetadata.builder(AbstractSarldocCommand.class).description(Messages.SarldocCommand_0)));
        this.logger = logger;
        this.config = config;
        this.sarlcConfig = sarlcConfig;
        this.pathDetector = pathDetector;
    }

    private static CommandMetadata.Builder addName(String name, CommandMetadata.Builder builder) {
        if (!Strings.isNullOrEmpty((String)name)) {
            return builder.name(name);
        }
        return builder;
    }

    public CommandOutcome run(Cli cli) {
        Logger logger = (Logger)this.logger.get();
        SarldocConfig dconfig = (SarldocConfig)this.config.get();
        AbstractSarldocCommand.forceProxyDefinition(dconfig, logger);
        CommandOutcome outcome = this.runSarlc(cli, logger);
        if (outcome.isSuccess()) {
            AtomicInteger warningCount;
            AtomicInteger errorCount;
            SarlcConfig cconfig = (SarlcConfig)this.sarlcConfig.get();
            outcome = this.runJavadoc(cli, dconfig, cconfig, logger, errorCount = new AtomicInteger(), warningCount = new AtomicInteger());
            if (outcome == null || outcome.isSuccess()) {
                if (warningCount.get() > 0) {
                    if (warningCount.get() > 1) {
                        logger.info(MessageFormat.format(Messages.SarldocCommand_7, warningCount.get()));
                    } else {
                        logger.info(MessageFormat.format(Messages.SarldocCommand_6, warningCount.get()));
                    }
                } else {
                    logger.info(Messages.SarldocCommand_4);
                }
            } else if (outcome.getException() != null) {
                logger.log(Level.SEVERE, outcome.getMessage(), outcome.getException());
            } else {
                logger.log(Level.SEVERE, outcome.getMessage());
            }
        }
        return outcome;
    }

    protected abstract CommandOutcome runSarlc(Cli var1, Logger var2);

    private static void addProxyFromProperty(Map<String, java.net.URI> activeProxies, String protocol, String hostVar, String portVar) {
        String host = System.getProperty(hostVar, null);
        if (!Strings.isNullOrEmpty((String)host)) {
            String port = System.getProperty(portVar, null);
            try {
                java.net.URI uri = Strings.isNullOrEmpty((String)port) ? new java.net.URI(String.format(SIMPLE_URL_PATTERN, protocol, host)) : new java.net.URI(String.format(PORT_URL_PATTERN, protocol, host, port));
                activeProxies.putIfAbsent(protocol, uri);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void addProxyFromEnvironment(Map<String, java.net.URI> activeProxies, String protocol, String var) {
        try {
            String host = System.getenv(var);
            if (!Strings.isNullOrEmpty((String)host)) {
                try {
                    java.net.URI uri = new java.net.URI(host);
                    activeProxies.putIfAbsent(protocol, uri);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static String ifNotEmpty(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return value;
    }

    private static String ifNotZero(int value) {
        if (value == 0) {
            return null;
        }
        return AbstractSarldocCommand.ifNotEmpty(Integer.toString(value));
    }

    private static void forceProxyDefinition(SarldocConfig config, Logger logger) {
        String url;
        HashMap<String, java.net.URI> activeProxies = new HashMap<String, java.net.URI>();
        AbstractSarldocCommand.addProxyFromEnvironment(activeProxies, HTTP_PROTOCOL_NAME, HTTP_HOST_VARIABLE_NAME);
        AbstractSarldocCommand.addProxyFromEnvironment(activeProxies, HTTPS_PROTOCOL_NAME, HTTPS_HOST_VARIABLE_NAME);
        AbstractSarldocCommand.addProxyFromProperty(activeProxies, HTTP_PROTOCOL_NAME, HTTP_HOST_PROPERTY_NAME, HTTP_PORT_PROPERTY_NAME);
        AbstractSarldocCommand.addProxyFromProperty(activeProxies, HTTPS_PROTOCOL_NAME, HTTPS_HOST_PROPERTY_NAME, HTTPS_PORT_PROPERTY_NAME);
        for (String proxyDefinition : config.getProxy()) {
            try {
                java.net.URI proxy = new java.net.URI(proxyDefinition);
                if (Strings.isNullOrEmpty((String)proxy.getHost())) continue;
                activeProxies.putIfAbsent(proxy.getScheme(), proxy);
            }
            catch (Throwable proxy) {}
        }
        java.net.URI uri = activeProxies.get(HTTPS_PROTOCOL_NAME);
        boolean hasHttps = false;
        String httpsHost = null;
        String httpsPort = null;
        String httpsNoProxy = config.getHttpsNoProxyHostsString();
        if (uri != null) {
            httpsHost = AbstractSarldocCommand.ifNotEmpty(uri.getHost());
            boolean bl = hasHttps = !Strings.isNullOrEmpty((String)httpsHost);
            if (hasHttps) {
                httpsNoProxy = System.getProperty(HTTPS_NONPROXYHOST_PROPERTY_NAME, httpsNoProxy);
                if (uri.getPort() != 0) {
                    httpsPort = AbstractSarldocCommand.ifNotZero(uri.getPort());
                }
            }
        }
        uri = activeProxies.get(HTTP_PROTOCOL_NAME);
        boolean hasHttp = false;
        String httpHost = null;
        String httpPort = null;
        String httpNoProxy = config.getHttpNoProxyHostsString();
        if (uri != null) {
            httpHost = AbstractSarldocCommand.ifNotEmpty(uri.getHost());
            boolean bl = hasHttp = !Strings.isNullOrEmpty((String)httpHost);
            if (hasHttp) {
                httpNoProxy = System.getProperty(HTTP_NONPROXYHOST_PROPERTY_NAME, httpNoProxy);
                if (uri.getPort() != 0) {
                    httpPort = AbstractSarldocCommand.ifNotZero(uri.getPort());
                }
            }
            if (!hasHttps && hasHttp) {
                httpsHost = httpHost;
                httpsPort = httpPort;
                httpsNoProxy = httpNoProxy;
                hasHttps = true;
            }
        }
        if (hasHttp) {
            url = Strings.isNullOrEmpty(httpPort) ? String.format(SIMPLE_URL_PATTERN, HTTP_PROTOCOL_NAME, httpHost) : String.format(PORT_URL_PATTERN, HTTP_PROTOCOL_NAME, httpHost, httpPort);
            logger.info(MessageFormat.format(Messages.SarldocCommand_8, HTTP_PROTOCOL_NAME, url));
            System.setProperty(HTTP_HOST_PROPERTY_NAME, httpHost);
            System.setProperty(HTTP_PORT_PROPERTY_NAME, httpPort);
            logger.fine(MessageFormat.format(Messages.SarldocCommand_9, HTTP_PROTOCOL_NAME, httpNoProxy));
            System.setProperty(HTTP_NONPROXYHOST_PROPERTY_NAME, httpNoProxy);
        }
        if (hasHttps) {
            url = Strings.isNullOrEmpty((String)httpsPort) ? String.format(SIMPLE_URL_PATTERN, HTTPS_PROTOCOL_NAME, httpsHost) : String.format(PORT_URL_PATTERN, HTTPS_PROTOCOL_NAME, httpsHost, httpsPort);
            logger.info(MessageFormat.format(Messages.SarldocCommand_8, HTTPS_PROTOCOL_NAME, url));
            System.setProperty(HTTPS_HOST_PROPERTY_NAME, httpsHost);
            System.setProperty(HTTPS_PORT_PROPERTY_NAME, httpsPort);
            logger.fine(MessageFormat.format(Messages.SarldocCommand_9, HTTPS_PROTOCOL_NAME, httpsNoProxy));
            System.setProperty(HTTPS_NONPROXYHOST_PROPERTY_NAME, httpsNoProxy);
        }
    }

    private static void addCmd(List<String> cmd, String option, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            cmd.add(option);
            cmd.add(value);
        }
    }

    private CommandOutcome runJavadoc(Cli cli, SarldocConfig docconfig, SarlcConfig cconfig, Logger logger, AtomicInteger errorCount, AtomicInteger warningCount) throws IllegalArgumentException {
        Class docletType;
        logger.info(Messages.SarldocCommand_2);
        ArrayList<String> cmd = new ArrayList<String>();
        AbstractSarldocCommand.addCmd(cmd, LOCALE_FLAG, docconfig.getLocale());
        String encoding = docconfig.getEncoding();
        AbstractSarldocCommand.addCmd(cmd, ENCODING_FLAG, encoding);
        JavaVersion javaVersion = SarlBatchCompilerUtils.parseJavaVersion((String)cconfig.getCompiler().getJavaVersion());
        AbstractSarldocCommand.addCmd(cmd, SOURCE_FLAG, javaVersion.getQualifier());
        String title = docconfig.getTitle();
        AbstractSarldocCommand.addCmd(cmd, DOCTITLE_FLAG, title);
        AbstractSarldocCommand.addCmd(cmd, "-title", title);
        if (!docconfig.getEnableDeprecatedTag()) {
            cmd.add("-nodeprecated");
        }
        if (!docconfig.getEnableSinceTag()) {
            cmd.add("-nosince");
        }
        if (docconfig.getEnableVersionTag()) {
            cmd.add("-version");
        }
        if (docconfig.getEnableAuthorTag()) {
            // empty if block
        }
        switch (docconfig.getVisibility()) {
            case PUBLIC: {
                cmd.add(PUBLIC_FLAG);
                break;
            }
            case PROTECTED: {
                cmd.add(PROTECTED_FLAG);
                break;
            }
            case PACKAGE: {
                cmd.add(PACKAGE_FLAG);
                break;
            }
            case PRIVATE: {
                cmd.add(PRIVATE_FLAG);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (Tag tag : docconfig.getCustomTags()) {
            AbstractSarldocCommand.addCmd(cmd, TAG_FLAG, tag.toString());
        }
        String docletName = docconfig.getDoclet();
        if (Strings.isNullOrEmpty((String)docletName)) {
            docletType = Doclet.class;
        } else {
            try {
                docletType = ((Object)((Object)this)).getClass().getClassLoader().loadClass(docletName);
            }
            catch (ClassNotFoundException exception) {
                return CommandOutcome.failed((int)255, (Throwable)exception);
            }
        }
        for (String option : docconfig.getJavadocOption()) {
            cmd.add(option);
        }
        DocumentationPathDetector paths = (DocumentationPathDetector)this.pathDetector.get();
        if (!paths.isResolved()) {
            paths.setSarlOutputPath(cconfig.getOutputPath());
            paths.setClassOutputPath(cconfig.getClassOutputPath());
            paths.setTempDirectory(cconfig.getTempDirectory());
            paths.setDocumentationOutputPath(docconfig.getDocumentationOutputDirectory());
            try {
                paths.resolve(cli.standaloneArguments());
            }
            catch (IOException exception) {
                return CommandOutcome.failed((int)255, (Throwable)exception);
            }
        }
        AbstractSarldocCommand.addCmd(cmd, "-directory", paths.getDocumentationOutputPath().getAbsolutePath());
        SystemPath sourcePath = new SystemPath();
        for (String path : cli.standaloneArguments()) {
            sourcePath.add(path);
        }
        if (paths.getSarlOutputPath() != null) {
            sourcePath.add(paths.getSarlOutputPath());
        }
        Collection<File> files = AbstractSarldocCommand.getSourceFiles(sourcePath, docconfig);
        return this.runJavadoc(files, paths, docletType, cmd, docconfig, logger, errorCount, warningCount);
    }

    protected abstract CommandOutcome runJavadoc(Collection<File> var1, DocumentationPathDetector var2, Class<?> var3, List<String> var4, SarldocConfig var5, Logger var6, AtomicInteger var7, AtomicInteger var8);

    private static boolean isExcludedPackage(File file, SarldocConfig config) {
        if (file == null) {
            return true;
        }
        Set<String> excl = config.getExcludedPackages();
        if (excl.isEmpty()) {
            return false;
        }
        StringBuilder name = new StringBuilder();
        boolean first = true;
        for (File cfile = file.getParentFile(); cfile != null && !Objects.equals(cfile.getName(), PACKAGE_SEPARATOR) && !Objects.equals(cfile.getName(), ".."); cfile = cfile.getParentFile()) {
            if (first) {
                first = false;
            } else {
                name.insert(0, PACKAGE_SEPARATOR);
            }
            name.insert(0, cfile.getName());
        }
        return !excl.contains(name.toString());
    }

    private static Collection<File> getSourceFiles(SystemPath sourcePaths, SarldocConfig config) {
        TreeSet<File> allFiles = new TreeSet<File>();
        PathTraverser pathTraverser = new PathTraverser();
        Multimap pathes = pathTraverser.resolvePathes(sourcePaths.toFilenameList(), input -> Objects.equals(JAVA_FILE_EXTENSION, input.fileExtension()));
        for (Map.Entry entry : pathes.entries()) {
            String filename = ((URI)entry.getValue()).toFileString();
            File file = FileSystem.convertStringToFile((String)filename);
            File root = FileSystem.convertStringToFile((String)((String)entry.getKey()));
            try {
                if (AbstractSarldocCommand.isExcludedPackage(FileSystem.makeRelative((File)file, (File)root), config)) continue;
                allFiles.add(file);
            }
            catch (Throwable throwable) {}
        }
        return allFiles;
    }
}

