/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.commands;

import com.google.common.base.Strings;
import io.bootique.cli.Cli;
import io.bootique.command.CommandManager;
import io.bootique.command.CommandOutcome;
import io.bootique.command.ManagedCommand;
import io.bootique.di.BQInject;
import io.sarl.docs.sarldoc.commands.AbstractSarldocCommand;
import io.sarl.docs.sarldoc.commands.Messages;
import io.sarl.docs.sarldoc.configs.SarldocConfig;
import io.sarl.docs.sarldoc.tools.DocumentationPathDetector;
import io.sarl.lang.sarlc.commands.CompilerCommand;
import io.sarl.lang.sarlc.configs.SarlcConfig;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.arakhne.afc.vmutil.FileSystem;

public class SarldocCommand
extends AbstractSarldocCommand {
    private final Provider<CommandManager> commandManagerProvider;

    @BQInject
    public SarldocCommand(Provider<CommandManager> commandManager, Provider<Logger> logger, Provider<SarldocConfig> config, Provider<SarlcConfig> sarlcConfig, Provider<DocumentationPathDetector> pathDetector) {
        super(logger, config, sarlcConfig, pathDetector, null);
        this.commandManagerProvider = commandManager;
    }

    @Override
    protected CommandOutcome runSarlc(Cli cli, Logger logger) {
        CommandOutcome outcome;
        try {
            logger.info(Messages.SarldocCommand_1);
            CommandManager cmdManager = (CommandManager)this.commandManagerProvider.get();
            ManagedCommand compilerCommand = cmdManager.lookupByType(CompilerCommand.class);
            outcome = compilerCommand.getCommand().run(cli);
        }
        catch (Exception e) {
            outcome = CommandOutcome.failed((int)1, (Throwable)e);
        }
        return outcome;
    }

    protected static String formatDiagnosticMessage(Diagnostic<? extends JavaFileObject> diagnostic) {
        String sourceName;
        String code = diagnostic.getCode();
        JavaFileObject source = diagnostic.getSource();
        long line = diagnostic.getLineNumber();
        long column = diagnostic.getColumnNumber();
        String diagMessage = diagnostic.getMessage(null);
        if (Strings.isNullOrEmpty((String)diagMessage)) {
            diagMessage = MessageFormat.format(Messages.SarldocCommand_10, code);
        }
        if (Strings.isNullOrEmpty((String)(sourceName = source != null ? source.getName() : null))) {
            return MessageFormat.format(Messages.SarldocCommand_11, diagMessage);
        }
        return MessageFormat.format(Messages.SarldocCommand_12, diagMessage, sourceName, line, column);
    }

    @Override
    protected CommandOutcome runJavadoc(Collection<File> sourceFiles, DocumentationPathDetector paths, Class<?> docletClass, List<String> javadocOptions, SarldocConfig docconfig, Logger logger, AtomicInteger errorCount, AtomicInteger warningCount) {
        try {
            File outFolder = paths.getDocumentationOutputPath().getAbsoluteFile();
            logger.info(MessageFormat.format(Messages.SarldocCommand_5, outFolder.getAbsolutePath()));
            FileSystem.delete((File)outFolder);
            outFolder.mkdirs();
            DiagnosticListener diagnosticListener = diagnostic -> {
                switch (diagnostic.getKind()) {
                    case ERROR: {
                        errorCount.incrementAndGet();
                        logger.severe(SarldocCommand.formatDiagnosticMessage(diagnostic));
                        break;
                    }
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        warningCount.incrementAndGet();
                        logger.warning(SarldocCommand.formatDiagnosticMessage(diagnostic));
                        break;
                    }
                    case NOTE: {
                        logger.info(SarldocCommand.formatDiagnosticMessage(diagnostic));
                        break;
                    }
                    case OTHER: {
                        logger.config(SarldocCommand.formatDiagnosticMessage(diagnostic));
                        break;
                    }
                }
            };
            DocumentationTool docTool = ToolProvider.getSystemDocumentationTool();
            StandardJavaFileManager fileManager = docTool.getStandardFileManager(diagnosticListener, null, null);
            Iterable<? extends JavaFileObject> javaFiles = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
            fileManager.setLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT, Arrays.asList(outFolder));
            DocumentationTool.DocumentationTask docTask = docTool.getTask(new ErrorWriter(logger, errorCount), fileManager, diagnosticListener, docletClass, javadocOptions, javaFiles);
            boolean result = docTask.call();
            if (result) {
                return CommandOutcome.succeeded();
            }
            return CommandOutcome.failed((int)255, (String)"");
        }
        catch (Throwable exception) {
            return CommandOutcome.failed((int)255, (Throwable)exception);
        }
    }

    private static class ErrorWriter
    extends Writer {
        protected final Logger logger;
        protected final AtomicInteger errorCount;

        ErrorWriter(Logger logger, AtomicInteger errorCount) {
            this.logger = logger;
            this.errorCount = errorCount;
        }

        @Override
        public final void flush() throws IOException {
        }

        @Override
        public final void close() throws IOException {
        }

        @Override
        public final void write(char[] cbuf, int off, int len) throws IOException {
            String message = new String(cbuf, off, len);
            if (!Strings.isNullOrEmpty((String)(message = message.trim()))) {
                this.log(message);
            }
        }

        protected void log(String message) {
            this.logger.severe(message);
            this.errorCount.incrementAndGet();
        }
    }
}

