/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.configs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import io.sarl.docs.sarldoc.configs.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public enum Placement {
    DISABLE('X', Messages.Placement_0),
    ALL('a', Messages.Placement_1),
    OVERVIEW('o', Messages.Placement_2),
    PACKAGES('p', Messages.Placement_3),
    TYPES('t', Messages.Placement_4),
    CONSTRUCTORS('c', Messages.Placement_5),
    METHODS('m', Messages.Placement_6),
    FIELDS('f', Messages.Placement_7);

    private final char placement;
    private final String documentation;

    private Placement(char placement, String documentation) {
        this.placement = placement;
        this.documentation = documentation;
    }

    public char toChar() {
        return this.placement;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public static Placement getDefault() {
        return ALL;
    }

    @JsonCreator
    public static Placement valueOfCaseInsensitive(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new NullPointerException("Name is null");
        }
        return Placement.valueOf(name.toUpperCase());
    }

    public static List<Placement> valuesOf(String text) {
        TreeMap<Character, Placement> all = new TreeMap<Character, Placement>();
        for (Placement placement : Placement.values()) {
            all.put(Character.valueOf(placement.toChar()), placement);
        }
        TreeSet<Placement> placements = new TreeSet<Placement>();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            Placement p = (Placement)((Object)all.get(Character.valueOf(text.charAt(i))));
            if (p == null) continue;
            placements.add(p);
        }
        return new ArrayList<Placement>(placements);
    }

    @JsonValue
    public String toJsonString() {
        return this.name().toLowerCase();
    }
}

