/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.configs;

import com.google.common.base.Strings;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.ConfigurationFactory;
import io.sarl.docs.sarldoc.configs.Messages;
import io.sarl.docs.sarldoc.configs.Tag;
import io.sarl.docs.sarldoc.configs.Visibility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.OperatingSystem;

@BQConfig(value="Configuration of sarldoc")
public class SarldocConfig {
    public static final String PREFIX = "sarldoc";
    public static final String JAVADOC_EXECUTABLE_NAME = "sarldoc.javadocExecutable";
    public static final String PROXY_NAME = "sarldoc.proxy";
    public static final String DOCLET_NAME = "sarldoc.doclet";
    public static final String DOCLET_PATH_NAME = "sarldoc.docletPath";
    public static final String DOC_OUTPUT_DIRECTORY_NAME = "sarldoc.documentationOutputDirectory";
    public static final File DOC_OUTPUT_DIRECTORY_FILE = FileSystem.join((File)new File("target"), (String[])new String[]{"site", "apidocs"});
    public static final String DOC_OUTPUT_DIRECTORY_VALUE = DOC_OUTPUT_DIRECTORY_FILE.getPath();
    public static final String JAVADOC_OPTION_NAME = "sarldoc.javadocOption";
    public static final String ENABLE_VERSION_TAG_NAME = "sarldoc.enableVesionTag";
    public static final String ENABLE_AUTHOR_TAG_NAME = "sarldoc.enableAuthorTag";
    public static final String ENABLE_DEPRECATED_TAG_NAME = "sarldoc.enableDeprecatedTag";
    public static final String ENABLE_SINCE_TAG_NAME = "sarldoc.enableSinceTag";
    public static final String TITLE_NAME = "sarldoc.title";
    public static final String VISIBILITY_NAME = "sarldoc.visibility";
    public static final String ENCODING_NAME = "sarldoc.encoding";
    public static final String LOCALE_NAME = "sarldoc.locale";
    public static final Locale LOCALE_DEFAULT = Locale.US;
    public static final String EXCLUDED_PACKAGES_NAME = "sarldoc.excludedPackages";
    public static final String TAGS_NAME = "sarldoc.tags";
    private static final String BIN_FOLDER = "bin";
    private static final String JAVADOC_BIN_WIN = "javadoc.exe";
    private static final String JAVADOC_BIN_UNIX = "javadoc";
    private static final String NOTMAC_LIB_FOLDER = "lib";
    private static final String MAC_LIB_FOLDER = "Classes";
    private static final String NOTMAC_TOOLS_JAR = "tools.jar";
    private static final String MAC_TOOLS_JAR = "Classes.jar";
    private static final String JAVA_HOME_PROPERTY_NAME = "JAVA_HOME";
    private static final String DEFAULT_NON_PROXY_HOSTS = "localhost|127.*.*.*|10.*.*.*";
    private static final char NO_PROXY_HOST_SEPARATOR = '|';
    private static final String NO_PROXY_HOST_SEPARATOR_STRING = "|";
    private static final String JAVA_HOME_KEY = "java.home";
    private String javadocExecutable;
    private List<String> proxy;
    private List<String> httpNoProxyHosts;
    private List<String> httpsNoProxyHosts;
    private List<String> javadocOption;
    private String doclet;
    private String docletPath;
    private String locale;
    private File documentationOutputDirectory;
    private boolean enableVesionTag = true;
    private boolean enableAuthorTag = true;
    private boolean enableDeprecatedTag = true;
    private boolean enableSinceTag = true;
    private String title;
    private String encoding;
    private Visibility visibility;
    private Set<String> excludedPackages;
    private List<Tag> customTags;

    public static SarldocConfig getConfiguration(ConfigurationFactory configFactory) {
        assert (configFactory != null);
        return (SarldocConfig)configFactory.config(SarldocConfig.class, PREFIX);
    }

    public String getJavadocExecutable() {
        if (this.javadocExecutable == null) {
            this.javadocExecutable = SarldocConfig.findJavadocExecutable();
        }
        return this.javadocExecutable;
    }

    @BQConfigProperty(value="Specify the path to the executable of Javadoc. If it is not specified, the value will be inferred from the current installation of the Java environment.")
    public void setJavadocExecutable(String javadocExecutable) {
        this.javadocExecutable = javadocExecutable;
    }

    public static String findJavadocExecutable() {
        String javadocCommand = OperatingSystem.getCurrentOS() == OperatingSystem.WIN ? JAVADOC_BIN_WIN : JAVADOC_BIN_UNIX;
        File javadocExe = FileSystem.join((File)new File(System.getProperty(JAVA_HOME_KEY)), (String[])new String[]{"..", BIN_FOLDER, javadocCommand});
        if (!(javadocExe.exists() && javadocExe.isFile() || (javadocExe = FileSystem.join((File)new File(System.getProperty(JAVA_HOME_KEY)), (String[])new String[]{BIN_FOLDER, javadocCommand})).exists() && javadocExe.isFile())) {
            String javaHome;
            try {
                javaHome = System.getenv(JAVA_HOME_PROPERTY_NAME);
                if (Strings.isNullOrEmpty((String)javaHome)) {
                    throw new RuntimeException(Messages.SarldocConfig_0);
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(Messages.SarldocConfig_0);
            }
            if (Strings.isNullOrEmpty((String)javaHome)) {
                throw new RuntimeException(Messages.SarldocConfig_0);
            }
            try {
                File javaHomeDirectory = FileSystem.convertStringToFile((String)javaHome).getCanonicalFile();
                if (!javaHomeDirectory.exists() || javaHomeDirectory.isFile()) {
                    throw new RuntimeException(MessageFormat.format(Messages.SarldocConfig_1, javaHome));
                }
                javadocExe = FileSystem.join((File)javaHomeDirectory, (String[])new String[]{BIN_FOLDER, javadocCommand});
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        try {
            File javadocExeCanon = javadocExe.getCanonicalFile();
            if (!javadocExeCanon.exists() || !javadocExeCanon.isFile()) {
                throw new RuntimeException(MessageFormat.format(Messages.SarldocConfig_2, javadocExe));
            }
            return javadocExe.getAbsolutePath();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static File findToolsJar() throws FileNotFoundException {
        String toolsJar;
        String libFolder;
        if (OperatingSystem.MACOSX.isCurrentOS()) {
            libFolder = MAC_LIB_FOLDER;
            toolsJar = MAC_TOOLS_JAR;
        } else {
            libFolder = NOTMAC_LIB_FOLDER;
            toolsJar = NOTMAC_TOOLS_JAR;
        }
        File file = FileSystem.join((File)new File(System.getProperty(JAVA_HOME_KEY)), (String[])new String[]{"..", libFolder, toolsJar});
        if (!file.exists() || !file.isFile()) {
            String javaHome;
            try {
                javaHome = System.getenv(JAVA_HOME_PROPERTY_NAME);
                if (Strings.isNullOrEmpty((String)javaHome)) {
                    throw new FileNotFoundException(Messages.SarldocConfig_3);
                }
            }
            catch (SecurityException ex) {
                throw new FileNotFoundException(Messages.SarldocConfig_3);
            }
            if (Strings.isNullOrEmpty((String)javaHome)) {
                throw new FileNotFoundException(Messages.SarldocConfig_3);
            }
            try {
                File javaHomeDirectory = FileSystem.convertStringToFile((String)javaHome).getCanonicalFile();
                if (!javaHomeDirectory.exists() || javaHomeDirectory.isFile()) {
                    throw new FileNotFoundException(Messages.SarldocConfig_3);
                }
                file = FileSystem.join((File)javaHomeDirectory, (String[])new String[]{libFolder, toolsJar});
            }
            catch (IOException exception) {
                throw new FileNotFoundException(Messages.SarldocConfig_3);
            }
        }
        try {
            File fileCanon = file.getCanonicalFile();
            if (!fileCanon.exists() || !fileCanon.isFile()) {
                throw new FileNotFoundException(Messages.SarldocConfig_3);
            }
            return fileCanon;
        }
        catch (IOException exception) {
            throw new FileNotFoundException(Messages.SarldocConfig_3);
        }
    }

    public List<String> getProxy() {
        if (this.proxy == null) {
            this.proxy = new ArrayList<String>();
        }
        return this.proxy;
    }

    @BQConfigProperty(value="Specify the network proxies.")
    public void setProxy(List<String> proxy) {
        this.proxy = proxy;
    }

    public List<String> getHttpNoProxyHosts() {
        if (this.httpNoProxyHosts == null) {
            this.httpNoProxyHosts = new ArrayList<String>();
            for (String host : org.eclipse.xtext.util.Strings.split((String)DEFAULT_NON_PROXY_HOSTS, (char)'|')) {
                if (Strings.isNullOrEmpty((String)host)) continue;
                this.httpNoProxyHosts.add(host);
            }
        }
        return this.httpNoProxyHosts;
    }

    public String getHttpNoProxyHostsString() {
        List<String> hosts = this.getHttpNoProxyHosts();
        if (hosts.isEmpty()) {
            return null;
        }
        return org.eclipse.xtext.util.Strings.concat((String)NO_PROXY_HOST_SEPARATOR_STRING, hosts);
    }

    @BQConfigProperty(value="Specify the host names for which the HTTP proxy should not be used. The character '*' may be used as a wildcard.")
    public void setHttpNoProxyHostsProxy(List<String> noProxyHosts) {
        this.httpNoProxyHosts = noProxyHosts;
    }

    public List<String> getHttpsNoProxyHosts() {
        if (this.httpsNoProxyHosts == null) {
            this.httpsNoProxyHosts = new ArrayList<String>();
            for (String host : org.eclipse.xtext.util.Strings.split((String)DEFAULT_NON_PROXY_HOSTS, (char)'|')) {
                if (Strings.isNullOrEmpty((String)host)) continue;
                this.httpsNoProxyHosts.add(host);
            }
        }
        return this.httpsNoProxyHosts;
    }

    public String getHttpsNoProxyHostsString() {
        List<String> hosts = this.getHttpsNoProxyHosts();
        if (hosts.isEmpty()) {
            return null;
        }
        return org.eclipse.xtext.util.Strings.concat((String)NO_PROXY_HOST_SEPARATOR_STRING, hosts);
    }

    @BQConfigProperty(value="Specify the host names for which the HTTPS proxy should not be used. The character '*' may be used as a wildcard.")
    public void setHttpsNoProxyHostsProxy(List<String> noProxyHosts) {
        this.httpsNoProxyHosts = noProxyHosts;
    }

    public List<String> getJavadocOption() {
        if (this.javadocOption == null) {
            this.javadocOption = new ArrayList<String>();
        }
        return this.javadocOption;
    }

    @BQConfigProperty(value="Specify the command-line options to pass directly to Javadoc.")
    public void setJavadocOptions(List<String> options) {
        this.javadocOption = options;
    }

    public String getDoclet() {
        return this.doclet;
    }

    @BQConfigProperty(value="Specify the class name of the doclet to use. If it is not specified, the default SARL doclet is used.")
    public void setDoclet(String doclet) {
        this.doclet = doclet;
    }

    public String getDocletPath() {
        return this.docletPath;
    }

    @BQConfigProperty(value="Specify the class path for the doclet. If it is not specified, the class path of this command is used.")
    public void setDocletPath(String path) {
        this.docletPath = path;
    }

    public File getDocumentationOutputDirectory() {
        if (this.documentationOutputDirectory == null) {
            this.documentationOutputDirectory = DOC_OUTPUT_DIRECTORY_FILE;
        }
        return this.documentationOutputDirectory;
    }

    @BQConfigProperty(value="Specify the output folder into which the generated HTML documentation will be copied. If it is not specified, the default sarldoc folder is used.")
    public void setDocumentationOutputDirectory(File outputDirectory) {
        this.documentationOutputDirectory = outputDirectory;
    }

    public boolean getEnableVersionTag() {
        return this.enableVesionTag;
    }

    @BQConfigProperty(value="Specify if the @version tags are enabled into the documentation. If it is not specified, the default is true.")
    public void setEnableVersionTag(boolean enable) {
        this.enableVesionTag = enable;
    }

    public boolean getEnableAuthorTag() {
        return this.enableAuthorTag;
    }

    @BQConfigProperty(value="Specify if the @author tags are enabled into the documentation. If it is not specified, the default is true.")
    public void setEnableAuthorTag(boolean enable) {
        this.enableAuthorTag = enable;
    }

    public boolean getEnableDeprecatedTag() {
        return this.enableDeprecatedTag;
    }

    @BQConfigProperty(value="Specify if the @deprecated tags are enabled into the documentation. If it is not specified, the default is true.")
    public void setEnableDeprecatedTag(boolean enable) {
        this.enableDeprecatedTag = enable;
    }

    public boolean getEnableSinceTag() {
        return this.enableSinceTag;
    }

    @BQConfigProperty(value="Specify if the @since tags are enabled into the documentation. If it is not specified, the default is true.")
    public void setEnableSinceTag(boolean enable) {
        this.enableSinceTag = enable;
    }

    public String getTitle() {
        return this.title;
    }

    @BQConfigProperty(value="Specify the title of the documentation.")
    public void setTitle(String title) {
        this.title = title;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().displayName();
        }
        return this.encoding;
    }

    @BQConfigProperty(value="Specify the character encoding of the documentation. If it is not specified, the value of the system property \"file.encoding\" is used. If this system property was not set, the default encoding is used (usually UTF-8).")
    public void setFileEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Visibility getVisibility() {
        if (this.visibility == null) {
            this.visibility = Visibility.getDefault();
        }
        return this.visibility;
    }

    @BQConfigProperty(value="Specify the visibiltiy of the elements that should appear into the documentation. If it is not specified, the protected visibility is assumed.")
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Set<String> getExcludedPackages() {
        if (this.excludedPackages == null) {
            this.excludedPackages = new HashSet<String>();
        }
        return this.excludedPackages;
    }

    @BQConfigProperty(value="Specify the list of the excluded packages.")
    public void setExcludedPackages(Set<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public List<Tag> getCustomTags() {
        if (this.customTags == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.customTags);
    }

    @BQConfigProperty(value="Specify the custom tags to be recognized by the documentation generator.")
    public void setCustomTags(List<Tag> customTags) {
        this.customTags = customTags == null || customTags.isEmpty() ? null : new ArrayList<Tag>(customTags);
    }

    @BQConfigProperty(value="Specify the custom tags to be recognized by the documentation generator.")
    public void setTags(String customTags) {
        this.customTags = Strings.isNullOrEmpty((String)customTags) ? null : Tag.valuesOf(customTags);
    }

    public String getLocale() {
        if (this.locale == null) {
            this.locale = LOCALE_DEFAULT.toString();
        }
        return this.locale;
    }

    @BQConfigProperty(value="Specify the locale of the documentation.")
    public void setLocale(String locale) {
        this.locale = locale;
    }
}

