/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.configs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import io.bootique.annotation.BQConfigProperty;
import io.sarl.docs.sarldoc.configs.Placement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class Tag {
    private static final String SEPARATOR = ":";
    private String name;
    private String header;
    private List<Placement> placement;

    public String getName() {
        return this.name;
    }

    @BQConfigProperty(value="Specify the name of the custom name. The provided name is the text that should appear after the '@' character.")
    public void setName(String name) {
        this.name = name;
    }

    public String getHeader() {
        if (Strings.isNullOrEmpty((String)this.header)) {
            this.header = this.getName();
        }
        return this.header;
    }

    @BQConfigProperty(value="Specify the text that is used as heading into the documentation each time the custom tag is used.")
    public void setHeader(String text) {
        this.header = text;
    }

    public List<Placement> getPlacements() {
        if (this.placement == null || this.placement.isEmpty()) {
            return Collections.singletonList(Placement.getDefault());
        }
        return Collections.unmodifiableList(this.placement);
    }

    @BQConfigProperty(value="Specify the placements for this custom tag.")
    public void setPlacements(List<Placement> placements) {
        this.placement = placements == null || placements.isEmpty() ? null : new ArrayList<Placement>(placements);
    }

    @JsonCreator
    public static Tag valueOf(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            throw new NullPointerException("text is null");
        }
        Tag tag = new Tag();
        String[] parts = text.split(Pattern.quote(SEPARATOR));
        if (parts != null) {
            if (parts.length > 0) {
                tag.setName(Strings.emptyToNull((String)parts[0]));
            }
            if (parts.length > 1) {
                tag.setPlacements(Placement.valuesOf(parts[1]));
            }
            if (parts.length > 2) {
                tag.setHeader(Strings.emptyToNull((String)parts[2]));
            }
        }
        if (!Strings.isNullOrEmpty((String)tag.getName())) {
            return tag;
        }
        return null;
    }

    public static List<Tag> valuesOf(String text) {
        String[] parts;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (!Strings.isNullOrEmpty((String)text) && (parts = text.split(Pattern.quote(SEPARATOR))) != null) {
            int i = 0;
            while (i + 2 < parts.length) {
                Tag tag = new Tag();
                tag.setName(Strings.emptyToNull((String)parts[i]));
                tag.setPlacements(Placement.valuesOf(parts[++i]));
                tag.setHeader(Strings.emptyToNull((String)parts[++i]));
                ++i;
                if (Strings.isNullOrEmpty((String)tag.getName())) continue;
                tags.add(tag);
            }
        }
        return tags;
    }

    @JsonValue
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String name = this.getName();
        if (!Strings.isNullOrEmpty((String)name)) {
            buffer.append(name);
        }
        buffer.append(SEPARATOR);
        for (Placement placement : this.getPlacements()) {
            buffer.append(placement.toChar());
        }
        buffer.append(SEPARATOR);
        String header = this.getHeader();
        if (!Strings.isNullOrEmpty((String)header)) {
            buffer.append(header);
        }
        return buffer.toString();
    }
}

