/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.modules.internal;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Key;
import io.bootique.di.Provides;
import io.sarl.apputils.bootiqueapp.utils.SystemProperties;
import io.sarl.docs.sarldoc.commands.SarldocCommand;
import io.sarl.docs.sarldoc.configs.SarldocConfig;
import io.sarl.docs.sarldoc.modules.internal.Messages;
import io.sarl.docs.sarldoc.tools.DefaultDocumentationPathDetector;
import io.sarl.docs.sarldoc.tools.DocumentationPathDetector;
import io.sarl.lang.core.util.CliUtilities;
import io.sarl.lang.sarlc.configs.ProgressBarConfig;
import io.sarl.lang.sarlc.tools.PathDetector;
import io.sarl.lang.sarlc.tools.SARLClasspathProvider;
import io.sarl.lang.sarlc.tools.SarlEmbededSdkClasspathProvider;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.arakhne.afc.bootique.applicationdata2.annotations.DefaultApplicationName;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationArgumentSynopsis;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationDetailedDescription;

public class SarldocApplicationModule
implements BQModule {
    public void configure(Binder binder) {
        binder.bind(PathDetector.class).to(DefaultDocumentationPathDetector.class).inSingletonScope();
        binder.bind(DocumentationPathDetector.class).to(DefaultDocumentationPathDetector.class).inSingletonScope();
        binder.bind(SARLClasspathProvider.class).to(SarlEmbededSdkClasspathProvider.class).inSingletonScope();
        binder.bind(Key.get(String.class, DefaultApplicationName.class)).toInstance((Object)SystemProperties.getValue((String)"sarldoc.programName", (String)"sarldoc"));
        BQCoreModule.extend((Binder)binder).setApplicationDescription(Messages.SarldocApplicationModule_0);
        binder.bind(Key.get(String.class, ApplicationDetailedDescription.class)).toJakartaProvider(LongDescriptionProvider.class).inSingletonScope();
        binder.bind(Key.get(String.class, ApplicationArgumentSynopsis.class)).toInstance((Object)Messages.SarldocApplicationModule_1);
        BQCoreModule.extend((Binder)binder).setDefaultCommand(SarldocCommand.class);
    }

    @Singleton
    @Provides
    public Logger provideRootLogger(ConfigurationFactory configFactory, Provider<ProgressBarConfig> config) {
        Logger logger;
        block9: {
            Class<?> type = this.getClass();
            InputStream stream = type.getResourceAsStream("logging.properties");
            try {
                ProgressBarConfig cfg;
                LogManager.getLogManager().readConfiguration(stream);
                Logger root = Logger.getAnonymousLogger();
                if (root != null && (cfg = (ProgressBarConfig)config.get()).getEnable()) {
                    root.setLevel(cfg.getLevel().toJul());
                }
                logger = root;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
            stream.close();
        }
        return logger;
    }

    private static class LongDescriptionProvider
    implements Provider<String> {
        private LongDescriptionProvider() {
        }

        public String get() {
            String sarlOutputDirectory = "src/main/generated-sources/sarl";
            String sarlOutputDirectoryOption = CliUtilities.getCommandLineOption((String)"directory");
            String javaOutputDirectory = "target/classes";
            String javaOutputDirectoryOption = CliUtilities.getCommandLineOption((String)"outputdir");
            String docOutputDirectory = SarldocConfig.DOC_OUTPUT_DIRECTORY_VALUE;
            String docOutputDirectoryOption = CliUtilities.getCommandLineOption((String)"docdirectory");
            return MessageFormat.format(Messages.SarldocApplicationModule_2, "src/main/generated-sources/sarl", sarlOutputDirectoryOption, "target/classes", javaOutputDirectoryOption, docOutputDirectory, docOutputDirectoryOption);
        }
    }
}

