/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.sarldoc.tools;

import com.google.common.collect.Iterables;
import io.sarl.docs.sarldoc.tools.DocumentationPathDetector;
import io.sarl.lang.sarlc.tools.DefaultPathDetector;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.arakhne.afc.vmutil.FileSystem;

public class DefaultDocumentationPathDetector
extends DefaultPathDetector
implements DocumentationPathDetector {
    private File documentationOutputPath;

    @Inject
    public DefaultDocumentationPathDetector() {
    }

    @Override
    public void setDocumentationOutputPath(File path) {
        this.documentationOutputPath = path;
    }

    @Override
    public File getDocumentationOutputPath() {
        return this.documentationOutputPath;
    }

    public boolean isResolved() {
        return super.isResolved() && this.documentationOutputPath != null;
    }

    protected Iterable<File> buildResolvablePaths(Iterable<File> userFiles) {
        return Iterables.concat((Iterable)super.buildResolvablePaths(userFiles), Collections.singleton(this.documentationOutputPath));
    }

    protected void normalizePaths(File rootFile) {
        super.normalizePaths(rootFile);
        if (this.documentationOutputPath == null) {
            this.documentationOutputPath = DefaultDocumentationPathDetector.toFile((File)rootFile, (String)"target/sarl-api-docs");
        }
    }

    protected void makeAbsolutePaths() throws IOException {
        super.makeAbsolutePaths();
        if (this.documentationOutputPath == null) {
            this.documentationOutputPath = DefaultDocumentationPathDetector.toFile((File)DefaultDocumentationPathDetector.cwd(), (String)"target/sarl-api-docs").getCanonicalFile();
        }
        if (this.documentationOutputPath != null && !this.documentationOutputPath.isAbsolute()) {
            this.documentationOutputPath = FileSystem.join((File)DefaultDocumentationPathDetector.cwd(), (File[])new File[]{this.documentationOutputPath}).getCanonicalFile();
        }
    }
}

