/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import io.sarl.docs.generator.MavenJulHandler;
import io.sarl.docs.generator.Messages;
import io.sarl.docs.generator.markdown.MarkdownParser;
import io.sarl.docs.generator.parser.AbstractMarkerLanguageParser;
import io.sarl.docs.generator.parser.SarlDocumentationParser;
import io.sarl.docs.validator.DocumentationLogger;
import io.sarl.docs.validator.DocumentationSetup;
import io.sarl.docs.validator.ScriptExecutor;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import io.sarl.lang.core.util.SarlUtils;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Handler;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.JavaToolchain;
import org.arakhne.afc.vmutil.FileSystem;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public abstract class AbstractDocumentationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/target/documentation-temp", required=true)
    protected File tempDirectory;
    @Parameter(defaultValue="${basedir}/target/generated-documentation-sources", required=true)
    protected String testSourceDirectory;
    @Parameter
    protected List<String> sourceDirectories;
    @Parameter(defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    @Parameter(defaultValue="true", required=true)
    protected boolean overrideSourceDirectories;
    @Parameter(required=true, defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(required=true, defaultValue="${basedir}", readonly=true)
    protected File baseDirectory;
    @Parameter(required=false)
    protected List<String> fileExtensions;
    protected String targetLanguageFileExtension;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="false", required=false)
    protected boolean githubExtension;
    @Parameter(defaultValue="true", required=false)
    protected boolean isLineContinuationEnable;
    @Parameter(required=false)
    protected String source;
    protected Injector injector;
    protected List<String> inferredSourceDirectories;
    @Parameter(required=false)
    private Properties propertyDefaultValues;
    @Inject
    private ToolchainManager toolchainManager;
    @Inject
    private RepositorySystem repositorySystem;
    private ReflectExtensions reflect;

    private static boolean isFileExtension(File filename, String[] extensions) {
        String extension = FileSystem.extension((File)filename);
        for (String ext : extensions) {
            if (!Strings.equal((String)ext, (String)extension)) continue;
            return true;
        }
        return false;
    }

    protected abstract String getSkippingMessage();

    public final void execute() throws MojoExecutionException {
        String skipMessage = this.getSkippingMessage();
        if (!Strings.isEmpty((String)skipMessage)) {
            this.getLog().info((CharSequence)skipMessage);
            return;
        }
        if (this.fileExtensions == null || this.fileExtensions.isEmpty()) {
            this.fileExtensions = Arrays.asList(MarkdownParser.MARKDOWN_FILE_EXTENSIONS);
        }
        if (this.sourceDirectories == null) {
            this.sourceDirectories = Collections.emptyList();
        }
        if (!this.sourceDirectories.isEmpty() && this.overrideSourceDirectories) {
            this.inferredSourceDirectories = Lists.newArrayList(this.sourceDirectories);
        } else {
            this.inferredSourceDirectories = Lists.newArrayList((Iterable)this.project.getCompileSourceRoots());
            this.inferredSourceDirectories.addAll(this.sourceDirectories);
            this.inferredSourceDirectories.add("src/main/documentation");
        }
        this.getLog().info((CharSequence)Messages.AbstractDocumentationMojo_0);
        DocumentationLogger.initializeLogger((Handler)new MavenJulHandler(this.getLog()));
        this.injector = DocumentationSetup.doSetup();
        assert (this.injector != null);
        if (this.reflect == null) {
            this.reflect = (ReflectExtensions)this.injector.getInstance(ReflectExtensions.class);
        }
        this.targetLanguageFileExtension = SarlUtils.getMajorFileExtension((String)((String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"file.extensions")))));
        String errorMessage = this.internalExecute();
        if (!Strings.isEmpty((String)errorMessage)) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    protected String internalExecute() {
        this.getLog().info((CharSequence)Messages.AbstractDocumentationMojo_1);
        Map<File, File> files = this.getFiles();
        this.getLog().info((CharSequence)MessageFormat.format(Messages.AbstractDocumentationMojo_2, files.size()));
        return this.internalExecute(files);
    }

    protected String internalExecute(Map<File, File> files) {
        throw new UnsupportedOperationException();
    }

    protected String internalExecute(Map<File, File> files, File outputFolder) {
        String firstErrorMessage = null;
        for (Map.Entry<File, File> entry : files.entrySet()) {
            File inputFile = entry.getKey();
            try {
                AbstractMarkerLanguageParser parser = this.createLanguageParser(inputFile);
                File sourceFolder = entry.getValue();
                File relativePath = FileSystem.makeRelative((File)inputFile, (File)sourceFolder);
                this.internalExecute(sourceFolder, inputFile, relativePath, outputFolder, parser);
            }
            catch (Throwable exception) {
                String errorMessage = this.formatErrorMessage(inputFile, exception);
                this.getLog().error((CharSequence)errorMessage);
                if (Strings.isEmpty(firstErrorMessage)) {
                    firstErrorMessage = errorMessage;
                }
                this.getLog().debug(exception);
            }
        }
        return firstErrorMessage;
    }

    protected void internalExecute(File sourceFolder, File inputFile, File relativeInputFile, File outputFolder, AbstractMarkerLanguageParser parser) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected String formatErrorMessage(File inputFile, Throwable exception) {
        File filename;
        boolean addExceptionName;
        int lineno = 0;
        if (exception instanceof SarlDocumentationParser.ParsingException) {
            SarlDocumentationParser.ParsingException pexception = (SarlDocumentationParser.ParsingException)exception;
            addExceptionName = false;
            File file = pexception.getFile();
            filename = file != null ? file : inputFile;
            lineno = pexception.getLineno();
        } else {
            addExceptionName = true;
            filename = inputFile;
        }
        for (String sourceDir : this.session.getCurrentProject().getCompileSourceRoots()) {
            File root = new File(sourceDir);
            if (!AbstractDocumentationMojo.isParentFile(filename, root)) continue;
            try {
                filename = FileSystem.makeRelative((File)filename, (File)root);
            }
            catch (IOException iOException) {}
            break;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(filename.toString());
        if (lineno > 0) {
            msg.append(":").append(lineno);
        }
        msg.append(": ");
        Throwable rootEx = Throwables.getRootCause((Throwable)exception);
        if (rootEx != null && (addExceptionName || rootEx != exception)) {
            msg.append(rootEx.getClass().getName());
            msg.append(" - ");
        }
        if (rootEx != null) {
            msg.append(rootEx.getLocalizedMessage());
            try (StringWriter swriter = new StringWriter();){
                try (PrintWriter writer = new PrintWriter(swriter);){
                    rootEx.printStackTrace(writer);
                }
                msg.append("\n");
                msg.append(swriter.toString());
            }
            catch (IOException exception2) {
                throw new Error(exception2);
            }
        }
        return msg.toString();
    }

    private static boolean isParentFile(File file, File root) {
        if (file.isAbsolute() && root.isAbsolute()) {
            try {
                String[] components1 = FileSystem.split((File)file.getCanonicalFile());
                String[] components2 = FileSystem.split((File)root.getCanonicalFile());
                for (int i = 0; i < components2.length; ++i) {
                    if (i < components1.length && Strings.equal((String)components2[i], (String)components1[i])) continue;
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected AbstractMarkerLanguageParser createLanguageParser(File inputFile) throws MojoExecutionException, IOException {
        JavaVersion javaVersion = SarlBatchCompilerUtils.parseJavaVersion((String)this.source);
        if (!AbstractDocumentationMojo.isFileExtension(inputFile, MarkdownParser.MARKDOWN_FILE_EXTENSIONS)) {
            throw new MojoExecutionException(MessageFormat.format(Messages.AbstractDocumentationMojo_3, inputFile));
        }
        AbstractMarkerLanguageParser parser = (AbstractMarkerLanguageParser)this.injector.getInstance(MarkdownParser.class);
        parser.setGithubExtensionEnable(this.githubExtension);
        SarlDocumentationParser internalParser = parser.getDocumentParser();
        if (this.isLineContinuationEnable) {
            internalParser.setLineContinuation(" ");
        } else {
            internalParser.addLowPropertyProvider(this.createProjectProperties());
        }
        ScriptExecutor scriptExecutor = internalParser.getScriptExecutor();
        StringBuilder cp = new StringBuilder();
        List<File> fullCp = this.getClassPath();
        for (File cpElement : fullCp) {
            if (cp.length() > 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(cpElement.getAbsolutePath());
        }
        scriptExecutor.setClassPath(cp.toString());
        StringBuilder mp = new StringBuilder();
        List<File> fullMp = this.getModulePath();
        for (File mpElement : fullMp) {
            if (mp.length() > 0) {
                mp.append(File.pathSeparator);
            }
            mp.append(mpElement.getAbsolutePath());
        }
        scriptExecutor.setModulePath(mp.toString());
        scriptExecutor.setClassLoaderBuilder(it -> this.getProjectClassLoader((ClassLoader)it, (Iterable<File>)fullCp, fullCp.size()));
        scriptExecutor.setJavaSourceVersion(javaVersion.getQualifier());
        scriptExecutor.setTempFolder(this.tempDirectory.getAbsoluteFile());
        internalParser.addLowPropertyProvider(this.createProjectProperties());
        internalParser.addLowPropertyProvider(this.session.getCurrentProject().getProperties());
        internalParser.addLowPropertyProvider(this.session.getUserProperties());
        internalParser.addLowPropertyProvider(this.session.getSystemProperties());
        internalParser.addLowPropertyProvider(this.createGeneratorProperties());
        Properties defaultValues = this.createDefaultValueProperties();
        if (defaultValues != null) {
            internalParser.addLowPropertyProvider(defaultValues);
        }
        return parser;
    }

    private Properties createDefaultValueProperties() {
        return this.propertyDefaultValues;
    }

    private Properties createProjectProperties() {
        Properties props = new Properties();
        MavenProject prj = this.session.getCurrentProject();
        props.put("project.groupId", Strings.emptyIfNull((String)prj.getGroupId()));
        props.put("project.artifactId", Strings.emptyIfNull((String)prj.getArtifactId()));
        props.put("project.basedir", prj.getBasedir() != null ? prj.getBasedir().getAbsolutePath() : "");
        props.put("project.description", Strings.emptyIfNull((String)prj.getDescription()));
        props.put("project.id", Strings.emptyIfNull((String)prj.getId()));
        props.put("project.inceptionYear", Strings.emptyIfNull((String)prj.getInceptionYear()));
        props.put("project.name", Strings.emptyIfNull((String)prj.getName()));
        props.put("project.version", Strings.emptyIfNull((String)prj.getVersion()));
        props.put("project.url", Strings.emptyIfNull((String)prj.getUrl()));
        props.put("project.encoding", Strings.emptyIfNull((String)this.encoding));
        return props;
    }

    private Properties createGeneratorProperties() {
        Properties props = new Properties();
        PluginDescriptor descriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        props.put("generator.name", Strings.emptyIfNull((String)descriptor.getArtifactId()));
        props.put("generator.version", Strings.emptyIfNull((String)descriptor.getVersion()));
        return props;
    }

    protected Map<File, File> getFiles() {
        TreeMap<File, File> files = new TreeMap<File, File>();
        for (String rootName : this.inferredSourceDirectories) {
            File root = FileSystem.convertStringToFile((String)rootName);
            if (!root.isAbsolute()) {
                root = FileSystem.makeAbsolute((File)root, (File)this.baseDirectory);
            }
            this.getLog().debug((CharSequence)MessageFormat.format(Messages.AbstractDocumentationMojo_4, root.getName()));
            for (File file : com.google.common.io.Files.fileTraverser().breadthFirst((Object)root)) {
                if (!file.exists() || !file.isFile() || file.isHidden() || !file.canRead() || !this.hasExtension(file)) continue;
                files.put(file, root);
            }
        }
        return files;
    }

    private boolean hasExtension(File file) {
        String extension = FileSystem.extension((File)file);
        return this.fileExtensions.contains(extension);
    }

    protected static String toPackageName(String rootPackage, File packageName) {
        StringBuilder name = new StringBuilder();
        for (File tmp = packageName; tmp != null; tmp = tmp.getParentFile()) {
            String elementName = tmp.getName();
            if (Strings.equal((String)".", (String)elementName) || Strings.equal((String)"..", (String)elementName)) continue;
            if (name.length() > 0) {
                name.insert(0, ".");
            }
            name.insert(0, elementName);
        }
        if (!Strings.isEmpty((String)rootPackage)) {
            if (name.length() > 0) {
                name.insert(0, ".");
            }
            name.insert(0, rootPackage);
        }
        return name.toString();
    }

    protected static File toPackageFolder(String packageName) {
        File file = null;
        for (String element : packageName.split("[.]")) {
            file = file == null ? new File(element) : new File(file, element);
        }
        return file;
    }

    protected List<File> getClassPath() throws IOException {
        LinkedHashSet<String> classPath = new LinkedHashSet<String>();
        MavenProject curProj = this.session.getCurrentProject();
        classPath.add(curProj.getBuild().getSourceDirectory());
        try {
            classPath.addAll(curProj.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        for (Artifact dep : curProj.getArtifacts()) {
            classPath.add(dep.getFile().getAbsolutePath());
        }
        classPath.remove(curProj.getBuild().getOutputDirectory());
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : classPath) {
            File file = new File(filename);
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    protected List<File> getModulePath() throws IOException {
        return new ArrayList<File>();
    }

    private ClassLoader getProjectClassLoader(ClassLoader parent, Iterable<File> classPath, int size) {
        try {
            URL[] urls = new URL[size];
            int i = 0;
            for (File localFile : classPath) {
                URL localUrl = FileSystem.convertFileToURL((File)localFile);
                if (localFile.isDirectory()) {
                    String name = localUrl.toExternalForm() + "/";
                    urls[i] = new URI(name).toURL();
                } else {
                    urls[i] = localUrl;
                }
                ++i;
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception exception) {
            throw new IOError(exception);
        }
    }

    @Deprecated(forRemoval=true, since="0.12")
    protected String getBootClassPath() throws IOException {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain instanceof JavaToolchain) {
            JavaToolchain javaToolChain = (JavaToolchain)toolchain;
            if (toolchain instanceof ToolchainPrivate) {
                Xpp3Dom bootClassPath;
                ToolchainPrivate privateJavaToolChain = (ToolchainPrivate)toolchain;
                String[] includes = new String[]{"jre/lib/*", "jre/lib/ext/*", "jre/lib/endorsed/*"};
                String[] excludes = new String[]{};
                Xpp3Dom config = (Xpp3Dom)privateJavaToolChain.getModel().getConfiguration();
                if (config != null && (bootClassPath = config.getChild("bootClassPath")) != null) {
                    Xpp3Dom excludeParent;
                    Xpp3Dom includeParent = bootClassPath.getChild("includes");
                    if (includeParent != null) {
                        includes = AbstractDocumentationMojo.getValues(includeParent.getChildren("include"));
                    }
                    if ((excludeParent = bootClassPath.getChild("excludes")) != null) {
                        excludes = AbstractDocumentationMojo.getValues(excludeParent.getChildren("exclude"));
                    }
                }
                try {
                    return AbstractDocumentationMojo.scanBootclasspath(Objects.toString(this.reflect.invoke((Object)javaToolChain, "getJavaHome", new Object[0])), includes, excludes);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
        }
        return "";
    }

    private static String scanBootclasspath(String javaHome, String[] includes, String[] excludes) {
        PathMatcher[] includeMatchers;
        File javaHomeFile = FileSystem.convertStringToFile((String)javaHome);
        Path javaHomePath = javaHomeFile.toPath();
        java.nio.file.FileSystem fs = javaHomePath.getFileSystem();
        if (includes != null && includes.length > 0) {
            includeMatchers = new PathMatcher[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                includeMatchers[i] = fs.getPathMatcher("glob:" + includes[i]);
            }
        } else {
            includeMatchers = null;
        }
        if (excludes != null && excludes.length > 0) {
            excludeMatchers = new PathMatcher[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                excludeMatchers[i] = fs.getPathMatcher("glob:" + excludes[i]);
            }
        } else {
            excludeMatchers = null;
        }
        DirectoryStream.Filter<Path> filter = entry -> {
            PathMatcher matcher;
            int i;
            boolean included;
            if (includeMatchers == null) {
                included = true;
            } else {
                included = false;
                for (i = 0; i < includeMatchers.length && !included; ++i) {
                    matcher = includeMatchers[i];
                    included = matcher.matches(entry.getFileName());
                }
            }
            if (included) {
                if (includeMatchers != null) {
                    for (i = 0; i < includeMatchers.length && !included; ++i) {
                        matcher = includeMatchers[i];
                        if (!matcher.matches(entry.getFileName())) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        };
        ArrayList<Path> includedFiles = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(javaHomeFile.toPath(), filter);){
            for (Path entry2 : stream) {
                includedFiles.add(entry2);
            }
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        StringBuilder bootClassPath = new StringBuilder();
        for (int i = 0; i < includedFiles.size(); ++i) {
            if (i > 0) {
                bootClassPath.append(File.pathSeparator);
            }
            bootClassPath.append(FileSystem.makeAbsolute((File)((Path)includedFiles.get(i)).toFile(), (File)javaHomeFile).getAbsolutePath());
        }
        return bootClassPath.toString();
    }

    private static String[] getValues(Xpp3Dom[] children) {
        String[] values = new String[children.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = children[i].getValue();
        }
        return values;
    }

    protected ArtifactResolutionResult resolve(ArtifactResolutionRequest request) throws MojoExecutionException {
        return this.repositorySystem.resolve(request);
    }

    protected Set<Artifact> resolve(String groupId, String artifactId, String version, String type) throws MojoExecutionException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveRoot(true);
        request.setResolveTransitively(true);
        request.setLocalRepository(this.session.getLocalRepository());
        request.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        request.setOffline(this.session.isOffline());
        request.setForceUpdate(this.session.getRequest().isUpdateSnapshots());
        request.setServers(this.session.getRequest().getServers());
        request.setMirrors(this.session.getRequest().getMirrors());
        request.setProxies(this.session.getRequest().getProxies());
        request.setArtifact(this.createArtifact(groupId, artifactId, version, type));
        ArtifactResolutionResult result = this.resolve(request);
        return result.getArtifacts();
    }

    protected Artifact createArtifact(String groupId, String artifactId, String version, String type) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, type);
    }
}

