/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator;

import com.google.common.base.Strings;
import io.sarl.docs.generator.AbstractDocumentationMojo;
import io.sarl.docs.generator.Messages;
import io.sarl.docs.generator.markdown.MarkdownParser;
import io.sarl.docs.generator.parser.AbstractMarkerLanguageParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.arakhne.afc.vmutil.FileSystem;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMojo
extends AbstractDocumentationMojo {
    @Parameter(defaultValue="${basedir}/target/classes", required=true)
    protected String outputDirectory;
    @Parameter(defaultValue="true", required=false)
    protected boolean md2html;
    @Parameter(defaultValue="true", required=false)
    protected boolean transformPureHtmlLinks;
    @Parameter(defaultValue="true", required=false)
    protected boolean autoSectionNumbering;
    @Parameter(required=false)
    protected String outlineStyleId;
    @Parameter(defaultValue="2-3", required=false)
    protected String outlineDepth;
    @Parameter(defaultValue="true", required=false)
    protected boolean outline;
    @Parameter(defaultValue="", required=false)
    protected String outlineExternalMarker;
    @Parameter(defaultValue="false", required=false)
    protected boolean kramdown;
    @Parameter(defaultValue="false", required=false)
    protected boolean addYamlHeader;
    @Parameter(defaultValue="true", required=false)
    protected boolean addLinkToOperationName;

    @Override
    protected String getSkippingMessage() {
        return null;
    }

    @Override
    protected AbstractMarkerLanguageParser createLanguageParser(File inputFile) throws MojoExecutionException, IOException {
        AbstractMarkerLanguageParser parser = super.createLanguageParser(inputFile);
        if (parser instanceof MarkdownParser) {
            MarkdownParser mdParser = (MarkdownParser)parser;
            mdParser.setAutoSectionNumbering(this.autoSectionNumbering);
            mdParser.setAddLinkToOperationName(this.addLinkToOperationName);
            mdParser.setOutlineDepthRange(AbstractMarkerLanguageParser.parseRange(this.outlineDepth, 1));
            mdParser.setMarkdownToHtmlReferenceTransformation(this.md2html);
            mdParser.setPureHtmlReferenceTransformation(this.transformPureHtmlLinks);
            mdParser.setOutlineStyleId(this.outlineStyleId);
            mdParser.setOutlineExternalMarker(this.outlineExternalMarker);
            mdParser.setOutlineGeneration(this.outline);
            mdParser.setKramdownFix(this.kramdown);
        }
        return parser;
    }

    @Override
    public String internalExecute(Map<File, File> files) {
        this.getLog().info((CharSequence)Messages.GenerateMojo_0);
        return this.internalExecute(files, FileSystem.convertStringToFile((String)this.outputDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalExecute(File sourceFolder, File inputFile, File relativeInputFile, File outputFolder, AbstractMarkerLanguageParser parser) throws IOException {
        this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateMojo_1, inputFile.getName()));
        String newContent = parser.transform(inputFile);
        this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateMojo_2, inputFile.getName()));
        File relativeFile = FileSystem.makeRelative((File)inputFile, (File)sourceFolder);
        File outputFile = FileSystem.makeAbsolute((File)relativeFile, (File)outputFolder);
        outputFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(outputFile);){
            if (this.addYamlHeader) {
                writer.write("---\ntitle: \"");
                writer.write(Strings.nullToEmpty((String)parser.extractPageTitle(newContent)));
                writer.write("\"\nlayout: default\n---\n\n");
            }
            writer.write(newContent);
            writer.flush();
        }
        catch (Throwable throwable) {
            this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateMojo_3, inputFile.getName()));
            throw throwable;
        }
        this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateMojo_3, inputFile.getName()));
    }
}

